/*
 * File:     ExplanationBrack.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>ExplanationBrack</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="ExplanationBrack" name="brack">
 *         <element java:className="Explanation" name="feat">
 *           <attribute name="type">
 *             <value>explanation</value>
 *           </attribute>
 *           <ref java:propertyName="language" name="attLang"/>
 *           <text java:propertyName="value"/>
 *         </element>
 *         <zeroOrMore>
 *           <ref java:propertyName="notes" name="note_explanation_struct_Desc"/>
 *         </zeroOrMore>
 *         <optional>
 *           <ref java:propertyName="source" name="source_explanation_struct_Desc"/>
 *         </optional>
 *       </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="ExplanationBrack" name="brack"&gt;
 *         &lt;element java:className="Explanation" name="feat"&gt;
 *           &lt;attribute name="type"&gt;
 *             &lt;value&gt;explanation&lt;/value&gt;
 *           &lt;/attribute&gt;
 *           &lt;ref java:propertyName="language" name="attLang"/&gt;
 *           &lt;text java:propertyName="value"/&gt;
 *         &lt;/element&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;ref java:propertyName="notes" name="note_explanation_struct_Desc"/&gt;
 *         &lt;/zeroOrMore&gt;
 *         &lt;optional&gt;
 *           &lt;ref java:propertyName="source" name="source_explanation_struct_Desc"/&gt;
 *         &lt;/optional&gt;
 *       &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class ExplanationBrack implements java.io.Serializable, Cloneable,
    IExplanation {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = -6126571001284701848L;
    private Explanation explanation_;

    // List<Note>
    private java.util.List notes_ = new java.util.ArrayList();
    private Source source_;

    /**
 * Creates a <code>ExplanationBrack</code>.
 *
 */
    public ExplanationBrack() {
    }

    /**
 * Creates a <code>ExplanationBrack</code>.
 *
 * @param source
 */
    public ExplanationBrack(ExplanationBrack source) {
        setup(source);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public ExplanationBrack(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public ExplanationBrack(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public ExplanationBrack(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ExplanationBrack(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>ExplanationBrack</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ExplanationBrack(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ExplanationBrack(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ExplanationBrack(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ExplanationBrack(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>ExplanationBrack</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ExplanationBrack(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the ExplanationBrack <code>source</code>.
 *
 * @param source
 */
    public void setup(ExplanationBrack source) {
        int size;

        if (source.explanation_ != null) {
            setExplanation((Explanation) source.getExplanation().clone());
        }

        this.notes_.clear();
        size = source.notes_.size();

        for (int i = 0; i < size; i++) {
            addNote((Note) source.getNotes(i).clone());
        }

        if (source.source_ != null) {
            setSource((Source) source.getSource().clone());
        }
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        setExplanation(new Explanation(stack));
        notes_.clear();

        while (true) {
            if (Note.isMatch(stack)) {
                addNote(new Note(stack));
            } else {
                break;
            }
        }

        if (Source.isMatch(stack)) {
            setSource(new Source(stack));
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new ExplanationBrack(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("brack");
        int size;
        this.explanation_.makeElement(element);
        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            Note value = (Note) this.notes_.get(i);
            value.makeElement(element);
        }

        if (this.source_ != null) {
            this.source_.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>ExplanationBrack</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ExplanationBrack</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the Explanation property <b>explanationStructDescBrackFeat</b>.
 *
 * @return Explanation
 */
    public Explanation getExplanation() {
        return (explanation_);
    }

    /**
 * Sets the Explanation property <b>explanationStructDescBrackFeat</b>.
 *
 * @param explanationStructDescBrackFeat
 */
    public void setExplanation(Explanation explanationStructDescBrackFeat) {
        this.explanation_ = explanationStructDescBrackFeat;
    }

    /**
 * Gets the Note property <b>notes</b>.
 *
 * @return Note[]
 */
    public Note[] getNotes() {
        Note[] array = new Note[notes_.size()];

        return ((Note[]) notes_.toArray(array));
    }

    /**
 * Sets the Note property <b>notes</b>.
 *
 * @param notes
 */
    public void setNotes(Note[] notes) {
        this.notes_.clear();

        for (int i = 0; i < notes.length; i++) {
            addNote(notes[i]);
        }
    }

    /**
 * Sets the Note property <b>notes</b>.
 *
 * @param notes
 */
    public void setNotes(Note notes) {
        this.notes_.clear();
        addNote(notes);
    }

    /**
 * Adds the Note property <b>notes</b>.
 *
 * @param notes
 */
    public void addNote(Note notes) {
        this.notes_.add(notes);
    }

    /**
 * Adds the Note property <b>notes</b>.
 *
 * @param notes
 */
    public void addNotes(Note[] notes) {
        for (int i = 0; i < notes.length; i++) {
            addNote(notes[i]);
        }
    }

    /**
 * Gets number of the Note property <b>notes</b>.
 *
 * @return int
 */
    public int sizeNotes() {
        return (notes_.size());
    }

    /**
 * Gets the Note property <b>notes</b> by index.
 *
 * @param index
 * @return Note
 */
    public Note getNotes(int index) {
        return ((Note) notes_.get(index));
    }

    /**
 * Sets the Note property <b>notes</b> by index.
 *
 * @param index
 * @param notes
 */
    public void setNote(int index, Note notes) {
        this.notes_.set(index, notes);
    }

    /**
 * Adds the Note property <b>notes</b> by index.
 *
 * @param index
 * @param notes
 */
    public void addNote(int index, Note notes) {
        this.notes_.add(index, notes);
    }

    /**
 * Remove the Note property <b>notes</b> by index.
 *
 * @param index
 */
    public void removeNote(int index) {
        this.notes_.remove(index);
    }

    /**
 * Remove the Note property <b>notes</b> by object.
 *
 * @param notes
 */
    public void removeNote(Note notes) {
        this.notes_.remove(notes);
    }

    /**
 * Clear the Note property <b>notes</b>.
 *
 */
    public void clearNotes() {
        this.notes_.clear();
    }

    /**
 * Gets the Source property <b>source</b>.
 *
 * @return Source
 */
    public Source getSource() {
        return (source_);
    }

    /**
 * Sets the Source property <b>source</b>.
 *
 * @param source
 */
    public void setSource(Source source) {
        this.source_ = source;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<brack");
        buffer.append(">");
        explanation_.makeTextElement(buffer);
        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            Note value = (Note) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        if (source_ != null) {
            source_.makeTextElement(buffer);
        }

        buffer.append("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<brack");
        buffer.write(">");
        explanation_.makeTextElement(buffer);
        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            Note value = (Note) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        if (source_ != null) {
            source_.makeTextElement(buffer);
        }

        buffer.write("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<brack");
        buffer.print(">");
        explanation_.makeTextElement(buffer);
        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            Note value = (Note) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        if (source_ != null) {
            source_.makeTextElement(buffer);
        }

        buffer.print("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>ExplanationBrack</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "brack")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!Explanation.isMatchHungry(target)) {
            return (false);
        }

        while (true) {
            if (!Note.isMatchHungry(target)) {
                break;
            }
        }

        if (Source.isMatchHungry(target)) {
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>ExplanationBrack</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>ExplanationBrack</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
