/*
 * File:     LanguageSection.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>LanguageSection</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="LanguageSection" name="struct">
 *       <attribute name="type">
 *         <value>LS</value>
 *       </attribute>
 *         <attribute name="xml:lang" />
 *       <ref name="attId"/>
 *         <element java:className="Language" name="feat">
 *                 <attribute name="type">
 *                   <value>language</value>
 *                 </attribute>
 *                 <text java:propertyName="value"/>
 *       </element>
 *       <zeroOrMore>
 *         <ref java:propertyName="conceptualDomains" name="conceptualDomain_struct_LS"/>
 *       </zeroOrMore>
 *           <zeroOrMore>
 *         <ref java:propertyName="examples" name="explanation_struct_LS"/>
 *       </zeroOrMore>      
 *          <zeroOrMore>
 *         <ref java:propertyName="examples" name="example_struct_LS"/>
 *       </zeroOrMore>
 *          <zeroOrMore>
 *         <ref java:propertyName="notes" name="note_struct_LS"/>
 *       </zeroOrMore>
 *          <zeroOrMore>
 *         <ref java:propertyName="definitions" name="definition_struct_LS"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *         <ref java:propertyName="nameSections" name="struct_NS"/>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="LanguageSection" name="struct"&gt;
 *       &lt;attribute name="type"&gt;
 *         &lt;value&gt;LS&lt;/value&gt;
 *          &lt;attribute name="xml:lang"&gt;
 *       &lt;/attribute&gt;
 *       &lt;ref name="attId"/&gt;
 *          &lt;element java:className="Language" name="feat"&gt;
 *                 &lt;attribute name="type"&gt;
 *                   &lt;value&gt;language&lt;/value&gt;
 *                 &lt;/attribute&gt;
 *                 &lt;text java:propertyName="value"/&gt;
 *       &lt;/element&gt;
 *       
 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="conceptualDomains" name="conceptualDomain_struct_LS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *          &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="explanations" name="explanation_struct_LS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="examples" name="example_struct_LS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="notes" name="note_struct_LS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *          &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="definitions" name="definition_struct_LS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *          &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="nameSections" name="struct_NS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class LanguageSection implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = 131427413587850645L;

    /** Logger for this class and subclasses */
    protected final static Logger logger = Logger.getLogger("DCR");

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_LS = "LS";
    private String type_;
    private String id_;
    private Language language_;

    // List<NameSection>
    private java.util.List nameSections_ = new java.util.ArrayList();

    // List<ConceptualDomain>
    private java.util.List conceptualDomains_ = new java.util.ArrayList();

    // List<IDefinition>
    private java.util.List definitions_ = new java.util.ArrayList();

    // List<IExample>
    private java.util.List examples_ = new java.util.ArrayList();

    // List<IExplanation>
    private java.util.List explanations_ = new java.util.ArrayList();

    // List<INote>
    private java.util.List notes_ = new java.util.ArrayList();

    /**
 * Creates a <code>LanguageSection</code>.
 *
 */
    public LanguageSection() {
        type_ = "";
    }

    /**
 * Creates a <code>LanguageSection</code>.
 *
 * @param source
 */
    public LanguageSection(LanguageSection source) {
        setup(source);
    }

    /**
 * Creates a <code>LanguageSection</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public LanguageSection(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>LanguageSection</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public LanguageSection(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>LanguageSection</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public LanguageSection(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>LanguageSection</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public LanguageSection(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>LanguageSection</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public LanguageSection(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>LanguageSection</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public LanguageSection(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>LanguageSection</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public LanguageSection(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>LanguageSection</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public LanguageSection(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>LanguageSection</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public LanguageSection(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>LanguageSection</code> by the LanguageSection <code>source</code>.
 *
 * @param source
 */
    public void setup(LanguageSection source) {
        int size;
        setType(source.getType());
        setId(source.getId());

        if (source.language_ != null) {
            setLanguage((Language) source.getLanguage().clone());
        }

        this.nameSections_.clear();
        size = source.nameSections_.size();

        for (int i = 0; i < size; i++) {
            addNameSection((NameSection) source.getNameSection(i).clone());
        }

        this.conceptualDomains_.clear();
        size = source.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            addConceptualDomain((ConceptualDomain) source.getConceptualDomain(i)
                                                         .clone());
        }

        this.definitions_.clear();
        size = source.definitions_.size();

        for (int i = 0; i < size; i++) {
            addDefinition((IDefinition) source.getDefinition(i).clone());
        }

        this.explanations_.clear();
        size = source.explanations_.size();

        for (int i = 0; i < size; i++) {
            addExplanation((IExplanation) source.getExplanation(i).clone());
        }

        this.examples_.clear();
        size = source.examples_.size();

        for (int i = 0; i < size; i++) {
            addExample((IExample) source.getExample(i).clone());
        }

        this.notes_.clear();
        size = source.notes_.size();

        for (int i = 0; i < size; i++) {
            addNote((INote) source.getNote(i).clone());
        }
    }

    /**
 * Initializes the <code>LanguageSection</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>LanguageSection</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>LanguageSection</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        setLanguage(new Language(stack));

        conceptualDomains_.clear();

        while (true) {
            if (ConceptualDomain.isMatch(stack)) {
                addConceptualDomain(new ConceptualDomain(stack));
            } else {
                break;
            }
        }

        explanations_.clear();

        while (true) {
            if (ExplanationBrack.isMatch(stack)) {
                addExplanation(new ExplanationBrack(stack));
            } else if (Explanation.isMatch(stack)) {
                addExplanation(new Explanation(stack));
            } else {
                break;
            }
        }

        examples_.clear();

        while (true) {
            if (ExampleBrack.isMatch(stack)) {
                addExample(new ExampleBrack(stack));
            } else if (Example.isMatch(stack)) {
                addExample(new Example(stack));
            } else {
                break;
            }
        }

        notes_.clear();

        while (true) {
            if (Note.isMatch(stack)) {
                addNote(new Note(stack));
            } else if (NoteBrack.isMatch(stack)) {
                addNote(new NoteBrack(stack));
            } else {
                break;
            }
        }

        definitions_.clear();

        while (true) {
            if (DefinitionBrack.isMatch(stack)) {
                addDefinition(new DefinitionBrack(stack));
            } else if (Definition.isMatch(stack)) {
                addDefinition(new Definition(stack));
            } else {
                break;
            }
        }

        nameSections_.clear();

        while (true) {
            if (NameSection.isMatch(stack)) {
                addNameSection(new NameSection(stack));
            } else {
                break;
            }
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new LanguageSection(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("struct");
        int size;

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }

        this.language_.makeElement(element);
        size = this.nameSections_.size();

        for (int i = 0; i < size; i++) {
            NameSection value = (NameSection) this.nameSections_.get(i);
            value.makeElement(element);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeElement(element);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeElement(element);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeElement(element);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeElement(element);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>LanguageSection</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>LanguageSection</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>LanguageSection</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>LanguageSection</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>LanguageSection</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>LanguageSection</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>id</b>.
 *
 * @return String
 */
    public String getId() {
        return (id_);
    }

    /**
 * Sets the String property <b>id</b>.
 *
 * @param id
 */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
 * Gets the Language property <b>language</b>.
 *
 * @return Language
 */
    public Language getLanguage() {
        return (language_);
    }

    /**
 * Sets the Language property <b>language</b>.
 *
 * @param language
 */
    public void setLanguage(Language language) {
        this.language_ = language;
    }

    /**
 * Gets the NameSection property <b>nameSections</b>.
 *
 * @return NameSection[]
 */
    public NameSection[] getNameSections() {
        NameSection[] array = new NameSection[nameSections_.size()];

        return ((NameSection[]) nameSections_.toArray(array));
    }

    /**
 * Sets the NameSection property <b>nameSections</b>.
 *
 * @param nameSections
 */
    public void setNameSections(NameSection[] nameSections) {
        this.nameSections_.clear();

        for (int i = 0; i < nameSections.length; i++) {
            addNameSection(nameSections[i]);
        }
    }

    /**
 * Sets the NameSection property <b>nameSections</b>.
 *
 * @param nameSections
 */
    public void setNameSections(NameSection nameSections) {
        this.nameSections_.clear();
        addNameSection(nameSections);
    }

    /**
 * Adds the NameSection property <b>nameSections</b>.
 *
 * @param nameSections
 */
    public void addNameSection(NameSection nameSections) {
        this.nameSections_.add(nameSections);
    }

    /**
 * Adds the NameSection property <b>nameSections</b>.
 *
 * @param nameSections
 */
    public void addNameSections(NameSection[] nameSections) {
        for (int i = 0; i < nameSections.length; i++) {
            addNameSection(nameSections[i]);
        }
    }

    /**
 * Gets number of the NameSection property <b>nameSections</b>.
 *
 * @return int
 */
    public int sizeNameSections() {
        return (nameSections_.size());
    }

    /**
 * Gets the NameSection property <b>nameSections</b> by index.
 *
 * @param index
 * @return NameSection
 */
    public NameSection getNameSection(int index) {
        return ((NameSection) nameSections_.get(index));
    }

    /**
 * Sets the NameSection property <b>nameSections</b> by index.
 *
 * @param index
 * @param nameSections
 */
    public void setNameSection(int index, NameSection nameSections) {
        this.nameSections_.set(index, nameSections);
    }

    /**
 * Adds the NameSection property <b>nameSections</b> by index.
 *
 * @param index
 * @param nameSections
 */
    public void addNameSection(int index, NameSection nameSections) {
        this.nameSections_.add(index, nameSections);
    }

    /**
 * Remove the NameSection property <b>nameSections</b> by index.
 *
 * @param index
 */
    public void removeNameSection(int index) {
        this.nameSections_.remove(index);
    }

    /**
 * Remove the NameSection property <b>nameSections</b> by object.
 *
 * @param nameSections
 */
    public void removeNameSection(NameSection nameSections) {
        this.nameSections_.remove(nameSections);
    }

    /**
 * Clear the NameSection property <b>nameSections</b>.
 *
 */
    public void clearNameSections() {
        this.nameSections_.clear();
    }

    /**
 * Gets the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @return ConceptualDomain[]
 */
    public ConceptualDomain[] getConceptualDomains() {
        ConceptualDomain[] array = new ConceptualDomain[conceptualDomains_.size()];

        return ((ConceptualDomain[]) conceptualDomains_.toArray(array));
    }

    /**
 * Sets the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void setConceptualDomains(ConceptualDomain[] conceptualDomains) {
        this.conceptualDomains_.clear();

        for (int i = 0; i < conceptualDomains.length; i++) {
            addConceptualDomain(conceptualDomains[i]);
        }
    }

    /**
 * Sets the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void setConceptualDomains(ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.clear();
        addConceptualDomain(conceptualDomains);
    }

    /**
 * Adds the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void addConceptualDomain(ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.add(conceptualDomains);
    }

    /**
 * Adds the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void addConceptualDomains(ConceptualDomain[] conceptualDomains) {
        for (int i = 0; i < conceptualDomains.length; i++) {
            addConceptualDomain(conceptualDomains[i]);
        }
    }

    /**
 * Gets number of the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @return int
 */
    public int sizeConceptualDomains() {
        return (conceptualDomains_.size());
    }

    /**
 * Gets the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 * @return ConceptualDomain
 */
    public ConceptualDomain getConceptualDomain(int index) {
        return ((ConceptualDomain) conceptualDomains_.get(index));
    }

    /**
 * Sets the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 * @param conceptualDomains
 */
    public void setConceptualDomain(int index,
        ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.set(index, conceptualDomains);
    }

    /**
 * Adds the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 * @param conceptualDomains
 */
    public void addConceptualDomain(int index,
        ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.add(index, conceptualDomains);
    }

    /**
 * Remove the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 */
    public void removeConceptualDomain(int index) {
        this.conceptualDomains_.remove(index);
    }

    /**
 * Remove the ConceptualDomain property <b>conceptualDomains</b> by object.
 *
 * @param conceptualDomains
 */
    public void removeConceptualDomain(ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.remove(conceptualDomains);
    }

    /**
 * Clear the ConceptualDomain property <b>conceptualDomains</b>.
 *
 */
    public void clearConceptualDomains() {
        this.conceptualDomains_.clear();
    }

    /**
 * Gets the IDefinitionStructLSChoice property <b>definitionStructLS</b>.
 *
 * @return IDefinitionStructLSChoice[]
 */
    public IDefinition[] getDefinitions() {
        IDefinition[] array = new IDefinition[definitions_.size()];

        return ((IDefinition[]) definitions_.toArray(array));
    }

    /**
 * Sets the IDefinitionStructLSChoice property <b>definitionStructLS</b>.
 *
 * @param definitions definitionStructLS
 */
    public void setDefinitions(IDefinition[] definitions) {
        this.definitions_.clear();

        for (int i = 0; i < definitions.length; i++) {
            addDefinition(definitions[i]);
        }
    }

    /**
 * Sets the IDefinitionStructLSChoice property <b>definitionStructLS</b>.
 *
 * @param definition definitionStructLS
 */
    public void setDefinitions(IDefinition definition) {
        this.definitions_.clear();
        addDefinition(definition);
    }

    /**
 * Adds the IDefinitionproperty <b>definitionStructLS</b>.
 *
 * @param definition
 */
    public void addDefinition(IDefinition definition) {
        this.definitions_.add(definition);
    }

    /**
 * Adds the IDefinitionStructLSChoice property <b>definitionStructLS</b>.
 *
 * @param definitions definitionStructLS
 */
    public void addDefinitions(IDefinition[] definitions) {
        for (int i = 0; i < definitions.length; i++) {
            addDefinition(definitions[i]);
        }
    }

    /**
 * Gets number of the IDefinitionStructLSChoice property <b>definitionStructLS</b>.
 *
 * @return int
 */
    public int sizeDefinitions() {
        return (definitions_.size());
    }

    /**
 * Gets the IDefinitionStructLSChoice property <b>definitionStructLS</b> by index.
 *
 * @param index
 * @return IDefinitionStructLSChoice
 */
    public IDefinition getDefinition(int index) {
        return ((IDefinition) definitions_.get(index));
    }

    /**
 * Sets the IDefinitionStructLSChoice property <b>definitionStructLS</b> by index.
 *
 * @param index
 * @param definition definitionStructLS
 */
    public void setDefinition(int index, IDefinition definition) {
        this.definitions_.set(index, definition);
    }

    /**
 * Adds the IDefinitionStructLSChoice property <b>definitionStructLS</b> by index.
 *
 * @param index
 * @param definition definitionStructLS
 */
    public void addDefinition(int index, IDefinition definition) {
        this.definitions_.add(index, definition);
    }

    /**
 * Remove the IDefinitionStructLSChoice property <b>definitionStructLS</b> by index.
 *
 * @param index
 */
    public void removeDefinition(int index) {
        this.definitions_.remove(index);
    }

    /**
 * Remove the IDefinitionStructLSChoice property <b>definitionStructLS</b> by object.
 *
 * @param definition definitionStructLS
 */
    public void removeDefinition(IDefinition definition) {
        this.definitions_.remove(definition);
    }

    /**
 * Clear the IDefinitionStructLSChoice property <b>definitionStructLS</b>.
 *
 */
    public void clearDefinitions() {
        this.definitions_.clear();
    }

    /**
 * Gets the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 * @return IExampleStructLSChoice[]
 */
    public IExample[] getExamples() {
        IExample[] array = new IExample[examples_.size()];

        return ((IExample[]) examples_.toArray(array));
    }

    /**
 * Sets the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 * @param examples exampleStructLS
 */
    public void setExamples(IExample[] examples) {
        this.examples_.clear();

        for (int i = 0; i < examples.length; i++) {
            addExample(examples[i]);
        }
    }

    /**
 * Sets the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 * @param example exampleStructLS
 */
    public void setExamples(IExample example) {
        this.examples_.clear();
        addExample(example);
    }

    /**
 * Adds the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 * @param example exampleStructLS
 */
    public void addExample(IExample example) {
        this.examples_.add(example);
    }

    /**
 * Adds the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 * @param examples exampleStructLS
 */
    public void addExamples(IExample[] examples) {
        for (int i = 0; i < examples.length; i++) {
            addExample(examples[i]);
        }
    }

    /**
 * Gets number of the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 * @return int
 */
    public int sizeExamples() {
        return (examples_.size());
    }

    /**
 * Gets the IExampleStructLSChoice property <b>exampleStructLS</b> by index.
 *
 * @param index
 * @return IExampleStructLSChoice
 */
    public IExample getExample(int index) {
        return ((IExample) examples_.get(index));
    }

    /**
 * Sets the IExampleStructLSChoice property <b>exampleStructLS</b> by index.
 *
 * @param index
 * @param example exampleStructLS
 */
    public void setExample(int index, IExample example) {
        this.examples_.set(index, example);
    }

    /**
 * Adds the IExampleStructLSChoice property <b>exampleStructLS</b> by index.
 *
 * @param index
 * @param example exampleStructLS
 */
    public void addExample(int index, IExample example) {
        this.examples_.add(index, example);
    }

    /**
 * Remove the IExampleStructLSChoice property <b>exampleStructLS</b> by index.
 *
 * @param index
 */
    public void removeExample(int index) {
        this.examples_.remove(index);
    }

    /**
 * Remove the IExampleStructLSChoice property <b>exampleStructLS</b> by object.
 *
 * @param example exampleStructLS
 */
    public void removeExample(IExample example) {
        this.examples_.remove(example);
    }

    /**
 * Clear the IExampleStructLSChoice property <b>exampleStructLS</b>.
 *
 */
    public void clearExamples() {
        this.examples_.clear();
    }

    /**
 * Gets the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 * @return IExplanationStructLSChoice[]
 */
    public IExplanation[] getExplanations() {
        IExplanation[] array = new IExplanation[explanations_.size()];

        return ((IExplanation[]) explanations_.toArray(array));
    }

    /**
 * Sets the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 * @param explanations explanationStructLS
 */
    public void setExplanations(IExplanation[] explanations) {
        this.explanations_.clear();

        for (int i = 0; i < explanations.length; i++) {
            addExplanation(explanations[i]);
        }
    }

    /**
 * Sets the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 * @param explanation explanationStructLS
 */
    public void setExplanations(IExplanation explanation) {
        this.explanations_.clear();
        addExplanation(explanation);
    }

    /**
 * Adds the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 * @param explanation explanationStructLS
 */
    public void addExplanation(IExplanation explanation) {
        this.explanations_.add(explanation);
    }

    /**
 * Adds the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 * @param explanations explanationStructLS
 */
    public void addExplanations(IExplanation[] explanations) {
        for (int i = 0; i < explanations.length; i++) {
            addExplanation(explanations[i]);
        }
    }

    /**
 * Gets number of the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 * @return int
 */
    public int sizeExplanations() {
        return (explanations_.size());
    }

    /**
 * Gets the IExplanationStructLSChoice property <b>explanationStructLS</b> by index.
 *
 * @param index
 * @return IExplanationStructLSChoice
 */
    public IExplanation getExplanation(int index) {
        return ((IExplanation) explanations_.get(index));
    }

    /**
 * Sets the IExplanationStructLSChoice property <b>explanationStructLS</b> by index.
 *
 * @param index
 * @param explanation explanationStructLS
 */
    public void setExplanation(int index, IExplanation explanation) {
        this.explanations_.set(index, explanation);
    }

    /**
 * Adds the IExplanationStructLSChoice property <b>explanationStructLS</b> by index.
 *
 * @param index
 * @param explanation explanationStructLS
 */
    public void addExplanation(int index, IExplanation explanation) {
        this.explanations_.add(index, explanation);
    }

    /**
 * Remove the IExplanationStructLSChoice property <b>explanationStructLS</b> by index.
 *
 * @param index
 */
    public void removeExplanation(int index) {
        this.explanations_.remove(index);
    }

    /**
 * Remove the IExplanationStructLSChoice property <b>explanationStructLS</b> by object.
 *
 * @param explanation explanationStructLS
 */
    public void removeExplanation(IExplanation explanation) {
        this.explanations_.remove(explanation);
    }

    /**
 * Clear the IExplanationStructLSChoice property <b>explanationStructLS</b>.
 *
 */
    public void clearExplanations() {
        this.explanations_.clear();
    }

    /**
 * Gets the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 * @return INoteStructLSChoice[]
 */
    public INote[] getNotes() {
        INote[] array = new INote[notes_.size()];

        return ((INote[]) notes_.toArray(array));
    }

    /**
 * Sets the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 * @param notes noteStructLS
 */
    public void setNotes(INote[] notes) {
        this.notes_.clear();

        for (int i = 0; i < notes.length; i++) {
            addNote(notes[i]);
        }
    }

    /**
 * Sets the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 * @param note noteStructLS
 */
    public void setNotes(INote note) {
        this.notes_.clear();
        addNote(note);
    }

    /**
 * Adds the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 * @param note noteStructLS
 */
    public void addNote(INote note) {
        this.notes_.add(note);
    }

    /**
 * Adds the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 * @param notes noteStructLS
 */
    public void addNotes(INote[] notes) {
        for (int i = 0; i < notes.length; i++) {
            addNote(notes[i]);
        }
    }

    /**
 * Gets number of the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 * @return int
 */
    public int sizeNotes() {
        return (notes_.size());
    }

    /**
 * Gets the INoteStructLSChoice property <b>noteStructLS</b> by index.
 *
 * @param index
 * @return INoteStructLSChoice
 */
    public INote getNote(int index) {
        return ((INote) notes_.get(index));
    }

    /**
 * Sets the INoteStructLSChoice property <b>noteStructLS</b> by index.
 *
 * @param index
 * @param noteStructLS
 */
    public void setNote(int index, INote noteStructLS) {
        this.notes_.set(index, noteStructLS);
    }

    /**
 * Adds the INoteStructLSChoice property <b>noteStructLS</b> by index.
 *
 * @param index
 * @param note noteStructLS
 */
    public void addNote(int index, INote note) {
        this.notes_.add(index, note);
    }

    /**
 * Remove the INoteStructLSChoice property <b>noteStructLS</b> by index.
 *
 * @param index
 */
    public void removeNote(int index) {
        this.notes_.remove(index);
    }

    /**
 * Remove the INoteStructLSChoice property <b>noteStructLS</b> by object.
 *
 * @param note noteStructLS
 */
    public void removeNote(INote note) {
        this.notes_.remove(note);
    }

    /**
 * Clear the INoteStructLSChoice property <b>noteStructLS</b>.
 *
 */
    public void clearNotes() {
        this.notes_.clear();
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<struct");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.append(">");
        language_.makeTextElement(buffer);
        size = this.nameSections_.size();

        for (int i = 0; i < size; i++) {
            NameSection value = (NameSection) this.nameSections_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.append("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<struct");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.write(">");
        language_.makeTextElement(buffer);
        size = this.nameSections_.size();

        for (int i = 0; i < size; i++) {
            NameSection value = (NameSection) this.nameSections_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.write("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<struct");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.print(">");
        language_.makeTextElement(buffer);
        size = this.nameSections_.size();

        for (int i = 0; i < size; i++) {
            NameSection value = (NameSection) this.nameSections_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.print("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>LanguageSection</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "struct")) {
            logger.info("languageSection is not target element");

            return (false);
        }

        logger.info("Checking language section");

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", "LS")) {
            return (false);
        }

        if (!Language.isMatchHungry(target)) {
            logger.info("No language");

            return (false);
        }

        while (true) {
            if (!ConceptualDomain.isMatchHungry(target)) {
                break;
            }

            logger.info("Concept Domain is match");
        }

        while (true) {
            if (ExplanationBrack.isMatchHungry(target)) {
            } else if (Explanation.isMatchHungry(target)) {
            } else {
                break;
            }

            logger.info("explanation(brack) is match");
        }

        while (true) {
            if (ExampleBrack.isMatchHungry(target)) {
            } else if (Example.isMatchHungry(target)) {
            } else {
                break;
            }

            logger.info("examples is match");
        }

        while (true) {
            if (Note.isMatchHungry(target)) {
            } else if (NoteBrack.isMatchHungry(target)) {
            } else {
                break;
            }

            logger.info("notes(brack)");
        }

        while (true) {
            if (DefinitionBrack.isMatchHungry(target)) {
                logger.info("definitionbrack is match");
            } else if (Definition.isMatchHungry(target)) {
                logger.info("definition is match");
            } else {
                break;
            }
        }

        while (true) {
            if (!NameSection.isMatchHungry(target)) {
                break;
            }

            logger.info("NameSection is match");
        }

        if (!target.isEmptyElement()) {
            logger.info("not empty");

            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>LanguageSection</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>LanguageSection</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
