/*
 * File:     NoteBrack.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>NoteBrack</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="NoteBrack" name="brack">
 *         <element java:className="Note" name="feat">
 *           <attribute name="type">
 *             <value>note</value>
 *           </attribute>
 *           <ref java:propertyName="language" name="attLang"/>
 *           <text java:propertyName="value"/>
 *         </element>
 *         <optional>
 *           <ref java:propertyName="note" name="source_note_struct_LS"/>
 *         </optional>
 *       </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="NoteBrack" name="brack"&gt;
 *         &lt;element java:className="Note" name="feat"&gt;
 *           &lt;attribute name="type"&gt;
 *             &lt;value&gt;note&lt;/value&gt;
 *           &lt;/attribute&gt;
 *           &lt;ref java:propertyName="language" name="attLang"/&gt;
 *           &lt;text java:propertyName="value"/&gt;
 *         &lt;/element&gt;
 *         &lt;optional&gt;
 *           &lt;ref java:propertyName="note" name="source_note_struct_LS"/&gt;
 *         &lt;/optional&gt;
 *       &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class NoteBrack implements java.io.Serializable, Cloneable, INote {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = 8358089315827664081L;
    private Note note_;
    private Source source_;

    /**
 * Creates a <code>NoteBrack</code>.
 *
 */
    public NoteBrack() {
    }

    /**
 * Creates a <code>NoteBrack</code>.
 *
 * @param source
 */
    public NoteBrack(NoteBrack source) {
        setup(source);
    }

    /**
 * Creates a <code>NoteBrack</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public NoteBrack(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>NoteBrack</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public NoteBrack(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>NoteBrack</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public NoteBrack(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>NoteBrack</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public NoteBrack(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>NoteBrack</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public NoteBrack(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>NoteBrack</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public NoteBrack(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>NoteBrack</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public NoteBrack(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>NoteBrack</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public NoteBrack(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>NoteBrack</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public NoteBrack(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>NoteBrack</code> by the NoteBrack <code>source</code>.
 *
 * @param source
 */
    public void setup(NoteBrack source) {
        if (source.note_ != null) {
            setNote((Note) source.getNote().clone());
        }

        if (source.source_ != null) {
            setSource((Source) source.getSource().clone());
        }
    }

    /**
 * Initializes the <code>NoteBrack</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>NoteBrack</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>NoteBrack</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        setNote(new Note(stack));

        if (Source.isMatch(stack)) {
            setSource(new Source(stack));
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new NoteBrack(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("brack");
        this.note_.makeElement(element);

        if (this.source_ != null) {
            this.source_.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>NoteBrack</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>NoteBrack</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>NoteBrack</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>NoteBrack</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>NoteBrack</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>NoteBrack</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the Note property <b>noteStructLSBrackFeat</b>.
 *
 * @return Note
 */
    public Note getNote() {
        return (note_);
    }

    /**
 * Sets the Note property <b>noteStructLSBrackFeat</b>.
 *
 * @param noteStructLSBrackFeat
 */
    public void setNote(Note noteStructLSBrackFeat) {
        this.note_ = noteStructLSBrackFeat;
    }

    /**
 * Gets the Note property <b>note</b>.
 *
 * @return Note
 */
    public Source getSource() {
        return (source_);
    }

    /**
 * Sets the Note property <b>note</b>.
 *
 * @param note
 */
    public void setSource(Source note) {
        this.source_ = note;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<brack");
        buffer.append(">");
        note_.makeTextElement(buffer);

        if (source_ != null) {
            source_.makeTextElement(buffer);
        }

        buffer.append("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<brack");
        buffer.write(">");
        note_.makeTextElement(buffer);

        if (source_ != null) {
            source_.makeTextElement(buffer);
        }

        buffer.write("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<brack");
        buffer.print(">");
        note_.makeTextElement(buffer);

        if (source_ != null) {
            source_.makeTextElement(buffer);
        }

        buffer.print("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>NoteBrack</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "brack")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!Note.isMatchHungry(target)) {
            return (false);
        }

        if (Note.isMatchHungry(target)) {
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>NoteBrack</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>NoteBrack</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
