/*
 * File:     ProfileList.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>ProfileList</b> is generated from ListOfProfiles.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="ProfileList" name="STRUCT">
 *         <attribute name="type">
 *           <value>ListofProfiles</value> 
 *         </attribute>
 *         <zeroOrMore>
 *             <element java:className="Profile" java:propertyName="profiles" name="feat">
 *                 <attribute name="type">
 *                     <value>profile</value> 
 *                 </attribute>
 *                 <text/> 
 *              </element>
 *         </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="ProfileList" name="STRUCT"&gt;
 *         &lt;attribute name="type"&gt;
 *           &lt;value&gt;ListofProfiles&lt;/value&gt; 
 *         &lt;/attribute&gt;
 *         &lt;zeroOrMore&gt;
 *             &lt;element java:className="Profile" java:propertyName="profiles" name="feat"&gt;
 *                 &lt;attribute name="type"&gt;
 *                     &lt;value&gt;profile&lt;/value&gt; 
 *                 &lt;/attribute&gt;
 *                 &lt;text/&gt; 
 *              &lt;/element&gt;
 *         &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version ListOfProfiles.rng (Tue Sep 06 13:16:25 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class ProfileList implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = -6673206835204360272L;

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_LISTOFPROFILES = "ListofProfiles";
    private String type_;

    // List<Profile>
    private java.util.List profiles_ = new java.util.ArrayList();

    /**
 * Creates a <code>ProfileList</code>.
 *
 */
    public ProfileList() {
        type_ = "";
    }

    /**
 * Creates a <code>ProfileList</code>.
 *
 * @param source
 */
    public ProfileList(ProfileList source) {
        setup(source);
    }

    /**
 * Creates a <code>ProfileList</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public ProfileList(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>ProfileList</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public ProfileList(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>ProfileList</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public ProfileList(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>ProfileList</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ProfileList(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>ProfileList</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ProfileList(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>ProfileList</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ProfileList(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>ProfileList</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ProfileList(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>ProfileList</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ProfileList(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>ProfileList</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public ProfileList(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>ProfileList</code> by the ProfileList <code>source</code>.
 *
 * @param source
 */
    public void setup(ProfileList source) {
        int size;
        setType(source.getType());
        this.profiles_.clear();
        size = source.profiles_.size();

        for (int i = 0; i < size; i++) {
            addProfiles((Profile) source.getProfiles(i).clone());
        }
    }

    /**
 * Initializes the <code>ProfileList</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>ProfileList</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>ProfileList</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        profiles_.clear();

        while (true) {
            if (Profile.isMatch(stack)) {
                addProfiles(new Profile(stack));
            } else {
                break;
            }
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new ProfileList(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("STRUCT");
        int size;

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>ProfileList</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>ProfileList</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ProfileList</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ProfileList</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ProfileList</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>ProfileList</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the Profile property <b>profiles</b>.
 *
 * @return Profile[]
 */
    public Profile[] getProfiles() {
        Profile[] array = new Profile[profiles_.size()];

        return ((Profile[]) profiles_.toArray(array));
    }

    /**
 * Sets the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void setProfiles(Profile[] profiles) {
        this.profiles_.clear();

        for (int i = 0; i < profiles.length; i++) {
            addProfiles(profiles[i]);
        }
    }

    /**
 * Sets the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void setProfiles(Profile profiles) {
        this.profiles_.clear();
        addProfiles(profiles);
    }

    /**
 * Adds the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void addProfiles(Profile profiles) {
        this.profiles_.add(profiles);
    }

    /**
 * Adds the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void addProfiles(Profile[] profiles) {
        for (int i = 0; i < profiles.length; i++) {
            addProfiles(profiles[i]);
        }
    }

    /**
 * Gets number of the Profile property <b>profiles</b>.
 *
 * @return int
 */
    public int sizeProfiles() {
        return (profiles_.size());
    }

    /**
 * Gets the Profile property <b>profiles</b> by index.
 *
 * @param index
 * @return Profile
 */
    public Profile getProfiles(int index) {
        return ((Profile) profiles_.get(index));
    }

    /**
 * Sets the Profile property <b>profiles</b> by index.
 *
 * @param index
 * @param profiles
 */
    public void setProfiles(int index, Profile profiles) {
        this.profiles_.set(index, profiles);
    }

    /**
 * Adds the Profile property <b>profiles</b> by index.
 *
 * @param index
 * @param profiles
 */
    public void addProfiles(int index, Profile profiles) {
        this.profiles_.add(index, profiles);
    }

    /**
 * Remove the Profile property <b>profiles</b> by index.
 *
 * @param index
 */
    public void removeProfiles(int index) {
        this.profiles_.remove(index);
    }

    /**
 * Remove the Profile property <b>profiles</b> by object.
 *
 * @param profiles
 */
    public void removeProfiles(Profile profiles) {
        this.profiles_.remove(profiles);
    }

    /**
 * Clear the Profile property <b>profiles</b>.
 *
 */
    public void clearProfiles() {
        this.profiles_.clear();
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<STRUCT");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        buffer.append(">");
        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.append("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<STRUCT");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        buffer.write(">");
        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.write("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<STRUCT");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        buffer.print(">");
        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.print("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>ProfileList</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "STRUCT")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token",
                    "ListofProfiles")) {
            return (false);
        }

        while (true) {
            if (!Profile.isMatchHungry(target)) {
                break;
            }
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>ProfileList</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>ProfileList</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
