/*
 * File:     RegistrationStatus.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>RegistrationStatus</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="RegistrationStatus" name="feat">
 *       <attribute name="type">
 *         <value>registrationStatus</value>
 *       </attribute>
 *       <ref java:propertyName="language" name="attLang"/>
 *       <choice>
 *         <value>superseded</value>
 *         <value>candidate</value>
 *         <value>retired</value>
 *         <value>qualified</value>
 *         <value>standard</value>
 *       </choice>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="RegistrationStatus" name="feat"&gt;
 *       &lt;attribute name="type"&gt;
 *         &lt;value&gt;registrationStatus&lt;/value&gt;
 *       &lt;/attribute&gt;
 *       &lt;ref java:propertyName="language" name="attLang"/&gt;
 *       &lt;choice&gt;
 *         &lt;value&gt;superseded&lt;/value&gt;
 *         &lt;value&gt;candidate&lt;/value&gt;
 *         &lt;value&gt;retired&lt;/value&gt;
 *         &lt;value&gt;qualified&lt;/value&gt;
 *         &lt;value&gt;standard&lt;/value&gt;
 *       &lt;/choice&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class RegistrationStatus implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = 6976734795978962578L;

    /** Holds value of property DOCUMENT ME! */
    public static final String CONTENT_SUPERSEDED = "superseded";

    /** Holds value of property DOCUMENT ME! */
    public static final String CONTENT_CANDIDATE = "candidate";

    /** Holds value of property DOCUMENT ME! */
    public static final String CONTENT_RETIRED = "retired";

    /** Holds value of property DOCUMENT ME! */
    public static final String CONTENT_QUALIFIED = "qualified";

    /** Holds value of property DOCUMENT ME! */
    public static final String CONTENT_STANDARD = "standard";

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_REGISTRATIONSTATUS = "registrationStatus";
    private String content_;
    private String type_;
    private String xmlLang_;

    /**
 * Creates a <code>RegistrationStatus</code>.
 *
 */
    public RegistrationStatus() {
        type_ = "";
    }

    /**
 * Creates a <code>RegistrationStatus</code>.
 *
 * @param source
 */
    public RegistrationStatus(RegistrationStatus source) {
        setup(source);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public RegistrationStatus(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public RegistrationStatus(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public RegistrationStatus(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public RegistrationStatus(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>RegistrationStatus</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public RegistrationStatus(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public RegistrationStatus(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public RegistrationStatus(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public RegistrationStatus(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>RegistrationStatus</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public RegistrationStatus(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the RegistrationStatus <code>source</code>.
 *
 * @param source
 */
    public void setup(RegistrationStatus source) {
        setContent(source.getContent());
        setType(source.getType());
        setXmlLang(source.getXmlLang());
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        content_ = URelaxer.getElementPropertyAsString(element);

        if (!isValid(content_)) {
            throw new IllegalArgumentException("The specified [" + content_ +
                "]registrationStatus is not a valid status");
        }

        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        xmlLang_ = URelaxer.getAttributePropertyAsString(element, "xml:lang");
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new RegistrationStatus(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("feat");
        URelaxer.setElementPropertyByString(element, this.content_);

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.xmlLang_ != null) {
            URelaxer.setAttributePropertyByString(element, "xml:lang",
                this.xmlLang_);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>RegistrationStatus</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>RegistrationStatus</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>content</b>.
 *
 * @return String
 */
    public String getContent() {
        return (content_);
    }

    /**
 * Sets the String property <b>content</b>.
 *
 * @param content
 */
    public void setContent(String content) {
        this.content_ = content;
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>xmlLang</b>.
 *
 * @return String
 */
    public String getXmlLang() {
        return (xmlLang_);
    }

    /**
 * Sets the String property <b>xmlLang</b>.
 *
 * @param xmlLang
 */
    public void setXmlLang(String xmlLang) {
        this.xmlLang_ = xmlLang;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<feat");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (xmlLang_ != null) {
            buffer.append(" xml:lang=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
                        getXmlLang())));
            buffer.append("\"");
        }

        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.append("</feat>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<feat");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (xmlLang_ != null) {
            buffer.write(" xml:lang=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
                        getXmlLang())));
            buffer.write("\"");
        }

        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.write("</feat>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<feat");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (xmlLang_ != null) {
            buffer.print(" xml:lang=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
                        getXmlLang())));
            buffer.print("\"");
        }

        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.print("</feat>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getContentAsString() {
        return (URelaxer.getString(getContent()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getXmlLangAsString() {
        return (URelaxer.getString(getXmlLang()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setContentByString(String string) {
        setContent(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setXmlLangByString(String string) {
        setXmlLang(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>RegistrationStatus</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "feat")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token",
                    "registrationStatus")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValues(element, "token",
                    new String[] {
                        "superseded", "candidate", "retired", "qualified",
                        "standard"
                    })) {
            return (false);
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>RegistrationStatus</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>RegistrationStatus</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param a_registrationStatus DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static boolean isValid(String a_registrationStatus) {
        if (a_registrationStatus == null) {
            return false;
        }

        boolean isValid = false;
        List statusList = RegistrationStatus.getStatusList();

        if (statusList.contains(a_registrationStatus)) {
            isValid = true;
        }

        return isValid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static List getStatusList() {
        List list = new ArrayList();
        list.add(RegistrationStatus.CONTENT_CANDIDATE);
        list.add(RegistrationStatus.CONTENT_QUALIFIED);
        list.add(RegistrationStatus.CONTENT_RETIRED);
        list.add(RegistrationStatus.CONTENT_STANDARD);
        list.add(RegistrationStatus.CONTENT_SUPERSEDED);

        return list;
    }
}
