/*
 * File:     ISOCatConstants.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.dcr.isocat;


/**
 * Some ISOCat DCR constants.
 *
 * @author Han Sloetjes
 * @version 1.0
  */
public interface ISOCatConstants {
    /**
     * as of mid 2009 there is a new dcr model and the pid's have now a prefix
     */
    public static final String PID_PREFIX = "http://www.isocat.org/datcat/DC-";

    /** the base url of the REST service */
    public static final String BASE_URL = "http://www.isocat.org/rest/";

    /** the data category selection element */
    public static final String DCS = "dcif:dataCategorySelection";

    /** the data category element */
    public static final String DC = "dcif:dataCategory";

    /** profile element */
    public static final String PROF = "dcif:profile";

    /** the pid attribute */
    public static final String PID = "pid";

    /** id attribute */
    public static final String ID_ATT = "identifier";

    /** name attribute */
    public static final String NAME_ATT = "name";

    /** definition attribute */
    public static final String DEF_ATT = "definition";

    /** the isA element */
    public static final String IS_A = "isA";

    /** the identifier element */
    public static final String ID = "dcif:identifier";

    /** the name element */
    public static final String NAME = "dcif:name";

    /** the definition element */
    public static final String DEF = "dcif:definition";

    /** the language element */
    public static final String LANG = "dcif:language";

    /** the language section element */
    public static final String LANG_SEC = "dcif:languageSection";
}
