/*
 * File:     AnnotationNavigationPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JComponent;


/**
 * DOCUMENT ME!
 * $Id: AnnotationNavigationPanel.java 4129 2005-08-03 15:01:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class AnnotationNavigationPanel extends JComponent {
    private JButton butGoToPreviousAnnotation;
    private JButton butGoToNextAnnotation;
    private JButton butGoToLowerAnnotation;
    private JButton butGoToUpperAnnotation;

    /**
     * Creates a new AnnotationNavigationPanel instance
     *
     * @param buttonSize DOCUMENT ME!
     * @param theVM DOCUMENT ME!
     */
    public AnnotationNavigationPanel(Dimension buttonSize, ViewerManager2 theVM) {
        FlowLayout flowLayout = new FlowLayout(FlowLayout.LEFT, 0, 0);
        setLayout(flowLayout);

        butGoToPreviousAnnotation = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(),
                    ELANCommandFactory.PREVIOUS_ANNOTATION));
        butGoToPreviousAnnotation.setPreferredSize(buttonSize);
        add(butGoToPreviousAnnotation);

        butGoToNextAnnotation = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.NEXT_ANNOTATION));
        butGoToNextAnnotation.setPreferredSize(buttonSize);
        add(butGoToNextAnnotation);

        butGoToLowerAnnotation = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.ANNOTATION_DOWN));
        butGoToLowerAnnotation.setPreferredSize(buttonSize);
        add(butGoToLowerAnnotation);

        butGoToUpperAnnotation = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.ANNOTATION_UP));
        butGoToUpperAnnotation.setPreferredSize(buttonSize);
        add(butGoToUpperAnnotation);
    }
}
