/*
 * File:     ElanMacApplication.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.commands.global.AboutMA;
import mpi.eudico.client.annotator.commands.global.EditPreferencesMA;
import mpi.eudico.client.annotator.commands.global.MenuAction;

import mpi.eudico.client.annotator.util.ClientLogger;

import mpi.eudico.client.mac.MacApplicationListener;

import java.io.File;


/**
 * A class for handling Mac OS specific events.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class ElanMacApplication implements MacApplicationListener {
    /**
     * The "About" function from the main (screen) menu bar.
     */
    public void macHandleAbout() {
        MenuAction ma = new AboutMA("Menu.Help.About",
                (ElanFrame2) FrameManager.getInstance().getActiveFrame());
        ma.actionPerformed(null);
    }

    /**
     * Called when the application is launched. A file can be passed if  the
     * application is launched e.g. after a double click on a document.
     *
     * @param fileName the path to a file, or null
     */
    public void macHandleOpenApplication(String fileName) {
        if (fileName != null) {
            macHandleOpenFile(fileName);
        }
    }

    /**
     * Opens the specified file, the application is already running.
     *
     * @param fileName the path to a file or null
     */
    public void macHandleOpenFile(String fileName) {
        if (fileName != null) {
            File f = new File(fileName);

            try {
                if (!f.exists() || f.isDirectory()) {
                    ClientLogger.LOG.info("Cannot open file: " + fileName);

                    return;
                }

                FrameManager.getInstance().createFrame(f.getAbsolutePath());
            } catch (Exception ex) {
                ClientLogger.LOG.info("Cannot open file: " + ex.getMessage());
            }
        } else {
            ClientLogger.LOG.info("No file specified.");
        }
    }

    /**
     * The Preferences item from the main (screen) menu.
     */
    public void macHandlePreferences() {
        MenuAction ma2 = new EditPreferencesMA("Menu.Edit.Preferences.Edit",
                (ElanFrame2) FrameManager.getInstance().getActiveFrame());
        ma2.actionPerformed(null);
    }

    /**
     * Request to print a certain file. Not implemented yet.
     *
     * @param fileName the path to the file
     */
    public void macHandlePrintFile(String fileName) {
        ClientLogger.LOG.info(
            "Printing from Finder or other application not yet implemented.");
    }

    /**
     * Mac OS X specific handling of the main (screen) menu Quit application
     * event. Implementation of MacApplicationListener.
     */
    public void macHandleQuit() {
        FrameManager.getInstance().exit();
    }

    /**
     * Called when the running application is made the active application
     * (receives focus).  Do nothing.
     *
     * @param fileName the path to a file or null
     */
    public void macHandleReOpenApplication(String fileName) {
        //macHandleOpenFile (fileName);
    }
}
