/*
 * File:     PreferencesUser.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator;


/**
 * Extends the interface PreferencesListener with a method to set/change a
 * preference.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public interface PreferencesUser extends PreferencesListener {
    /**
     * Sets the preference with the specified key.
     *
     * @param key the key for the preference
     * @param value the value of the preference
     * @param document the document to set the preference for (a Transcription
     *        object)
     */
    public void setPreference(String key, Object value, Object document);
}
