/*
 * File:     ActiveAnnotationCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.server.corpora.clom.Annotation;

import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;


/**
 * DOCUMENT ME!
 * $Id: ActiveAnnotationCommand.java 4129 2005-08-03 15:01:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class ActiveAnnotationCommand implements Command {
    private String commandName;

    /**
     * Creates a new ActiveAnnotationCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public ActiveAnnotationCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2) receiver;
        Annotation annot = (Annotation) arguments[0];

        vm.getActiveAnnotation().setAnnotation(annot);

        if (annot != null) {
            if (annot instanceof AlignableAnnotation) {
                vm.getSelection().setSelection(annot.getBeginTimeBoundary(),
                    annot.getEndTimeBoundary());

                if (!vm.getMediaPlayerController().isBeginBoundaryActive()) {
                    vm.getMediaPlayerController().toggleActiveSelectionBoundary();
                }
            } else if (annot instanceof RefAnnotation) {
                Annotation parent = annot;

                while (true) {
                    parent = parent.getParentAnnotation();

                    if ((parent == null) ||
                            parent instanceof AlignableAnnotation) {
                        break;
                    }
                }

                if (parent instanceof AlignableAnnotation) {
                    AlignableAnnotation aa = (AlignableAnnotation) parent;
                    vm.getSelection().setSelection(aa.getBeginTimeBoundary(),
                        aa.getEndTimeBoundary());
                }
            }

            vm.getMasterMediaPlayer().setMediaTime(annot.getBeginTimeBoundary());

            /* // different behavior in selectionmode / non-selectionmode
               if (!vm.getMediaPlayerController().getSelectionMode()) {
                   vm.getSelection().setSelection(annot.getBeginTimeBoundary(), annot.getEndTimeBoundary());
                   if (!vm.getMediaPlayerController().isBeginBoundaryActive()) {
                       vm.getMediaPlayerController().toggleActiveSelectionBoundary();
                   }
                   vm.getMasterMediaPlayer().setMediaTime(annot.getBeginTimeBoundary());
               }    else { //selection mode
                   if (!vm.getMediaPlayerController().isBeginBoundaryActive()) {
                       vm.getMasterMediaPlayer().setMediaTime(annot.getEndTimeBoundary());
                   }    else {
                       vm.getMasterMediaPlayer().setMediaTime(annot.getBeginTimeBoundary());
                   }
               }
               } else { // non-alignable annotation
                   vm.getMasterMediaPlayer().setMediaTime(annot.getBeginTimeBoundary());
               }
             */
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
