/*
 * File:     ClearSelectionAndModeCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;

import javax.swing.Action;


/**
 * Clears the selection and switches off the selection mode.
 *
 * @author HS
 * @version 1.0
  */
public class ClearSelectionAndModeCA extends CommandAction {
    /**
     * Creates a new ClearSelectionAndModeCA instance
     *
     * @param theVM viewer manager
     */
    public ClearSelectionAndModeCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.CLEAR_SELECTION_AND_MODE);

        putValue(Action.NAME, "");
    }

    /**
     * Creates a new command.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.CLEAR_SELECTION_AND_MODE);
    }

    /**
     * Returns the receiver, the selection.
     *
     * @return the Selection object
     */
    protected Object getReceiver() {
        return vm.getSelection();
    }

    /**
     * Returns the arguments.
     *
     * @return the arguments
     */
    protected Object[] getArguments() {
        return new Object[] { vm.getMediaPlayerController() };
    }

    /**
     * Overrides CommandAction's actionPerformed by doing nothing when there is
     * no  selection. The ClearSelectionCommand is undoable and we don't want
     * meaningless commands in the unod/redo list.
     *
     * @param event the action event
     */
    public void actionPerformed(ActionEvent event) {
        if (vm.getSelection().getBeginTime() == vm.getSelection().getEndTime()) {
            return;
        }

        super.actionPerformed(event);
    }
}
