/*
 * File:     ClearSelectionAndModeCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.ModePanel;
import mpi.eudico.client.annotator.Selection;


/**
 * Clears the selection and sets the selection mode to false.
 *
 * @author Han Sloetjes
 */
public class ClearSelectionAndModeCommand implements Command {
    private String commandName;

    /**
     * Constructor.
     *
     * @param name name of the command
     */
    public ClearSelectionAndModeCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the Selection
     * @param arguments the arguments:  <ul><li>arg[0] = the media player
     *        controller  (ElanMediaPlayerController)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        Selection selection = (Selection) receiver;
        ElanMediaPlayerController mediaPlayerController = (ElanMediaPlayerController) (arguments[0]);

        if (mediaPlayerController.getSelectionMode() == true) {
            ((ModePanel) mediaPlayerController.getModePanel()).updateSelectionMode(false);
            mediaPlayerController.doToggleSelectionMode();
            selection.setSelection(mediaPlayerController.getMediaTime(),
                mediaPlayerController.getMediaTime());
        } else {
            selection.setSelection(0, 0);
        }
    }

    /**
     * Returns the name.
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
