/*
 * File:     ClearSelectionCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;


/**
 * A CommandAction to clear the current selection.
 *
 * Jul 2006: changed the keyboard shortcut from ctrl/com + C to Alt + C to make Ctrl/Com + C available
 * for the copy annotation command.
 * @author MPI
 * @version 1.1
 */
public class ClearSelectionCA extends CommandAction {
    private Icon icon;

    /**
     * Creates a new ClearSelectionCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public ClearSelectionCA(ViewerManager2 theVM) {
        //super();
        super(theVM, ELANCommandFactory.CLEAR_SELECTION);

        icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ClearSelectionButton.gif"));
        putValue(SMALL_ICON, icon);
        putValue(Action.NAME, "");
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.CLEAR_SELECTION);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getSelection();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        Object[] args = new Object[1];
        args[0] = vm.getMediaPlayerController();

        return args;
    }

    /**
     * Overrides CommandAction's actionPerformed by doing nothing when there is
     * no  selection. The ClearSelectionCommand is undoable and we don't want
     * meaningless commands in the unod/redo list.
     *
     * @param event the action event
     */
    public void actionPerformed(ActionEvent event) {
        if (vm.getSelection().getBeginTime() == vm.getSelection().getEndTime()) {
            return;
        }

        super.actionPerformed(event);
    }
}
