/*
 * File:     DeleteTypeCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;


/**
 * Deletes a Linguistic Type from a Transcription.
 *
 * @author Han Sloetjes
 */
public class DeleteTypeCommand implements UndoableCommand {
    private String commandName;

    // receiver
    private Transcription transcription;

    // the LinguisticType to remove
    private LinguisticType linType;

    /**
     * Creates a new DeleteTypeCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public DeleteTypeCommand(String name) {
        commandName = name;
    }

    /**
     * DOCUMENT ME!
     */
    public void undo() {
        if (linType != null) {
            transcription.addLinguisticType(linType);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void redo() {
        if (linType != null) {
            transcription.removeLinguisticType(linType);
        }
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the Transcription
     * @param arguments the arguments: <ul><li>arg[0] = the Linguistic Type
     *        (LinguisticType)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        transcription = (Transcription) receiver;
        linType = (LinguisticType) arguments[0];

        transcription.removeLinguisticType(linType);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
