/*
 * File:     EditCVDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.gui.EditCVDialog;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import mpi.util.ControlledVocabulary;

import java.util.List;


/**
 * A Command that brings up a JDialog for defining and editing  Controlled
 * Vocabularies.
 *
 * @author Han Sloetjes
 */
public class EditCVDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new edit cv command.
     *
     * @param name the name of the command
     */
    public EditCVDlgCommand(String name) {
        commandName = name;
    }

    /**
     * Creates the edit cv dialog.
     *
     * @param receiver the transcription holding the controlled vocabularies
     * @param arguments null
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription transcription = (Transcription) receiver;
        new EditCVDialog(transcription).setVisible(true);

        // check if any of the CV (entries) has changed
        List allCvs = ((TranscriptionImpl) transcription).getControlledVocabularies();

        for (int i = 0; i < allCvs.size(); i++) {
            ControlledVocabulary cv = (ControlledVocabulary) allCvs.get(i);

            if (cv.isChanged()) {
                transcription.setChanged();

                break;
            }
        }
    }

    /**
     * Returns the name of the command
     *
     * @return the name
     */
    public String getName() {
        return null;
    }
}
