/*
 * File:     ExportCHATCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.export.CHATExportDlg;

import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;

import java.util.Vector;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;


/**
 * DOCUMENT ME!
 *
 * @author Hennie Brugman
 */
public class ExportCHATCommand implements Command {
    private String commandName;

    /**
     * Creates a new StoreCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public ExportCHATCommand(String name) {
        commandName = name;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        //arguments:
        //[0]: TranscriptionStore eafTranscriptionStore
        //[1]: Vector visibleTiers
        Transcription tr = (Transcription) receiver;
        TranscriptionStore eafTranscriptionStore = (TranscriptionStore) arguments[0];

        Vector visibleTiers;

        if (arguments[1] != null) {
            visibleTiers = (Vector) arguments[1];
        } else {
            visibleTiers = ELANCommandFactory.getViewerManager(tr)
                                             .getMultiTierControlPanel()
                                             .getVisibleTiers();
        }

        JFrame fr = ELANCommandFactory.getRootFrame(tr);

        JOptionPane.showMessageDialog(fr,
            ElanLocale.getString("ExportCHATDialog.Message.CLANutility"),
            "ELAN", JOptionPane.INFORMATION_MESSAGE);

        JDialog dlg = new CHATExportDlg(fr, true, tr, eafTranscriptionStore,
                visibleTiers);
        dlg.setVisible(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
