/*
 * File:     LoopModeCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.ModePanel;


//import mpi.eudico.client.annotator.player.ElanMediaPlayer;

/**
 *
 */
public class LoopModeCommand implements Command {
    private String commandName;
    private ElanMediaPlayerController mediaPlayerController;

    //private ElanMediaPlayer masterMediaPlayer;

    /**
     * Creates a new LoopModeCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public LoopModeCommand(String name) {
        commandName = name;
    }

    /**
     *
     */
    public void execute(Object receiver, Object[] arguments) {
        mediaPlayerController = (ElanMediaPlayerController) arguments[0];

        //masterMediaPlayer = (ElanMediaPlayer) arguments[1];
        // HS dec 20006: perform the same action, whether the player is playing or not
        updateLoopMode(!mediaPlayerController.getLoopMode());
        mediaPlayerController.doToggleLoopMode();

        /*
        if (!masterMediaPlayer.isPlaying()) {
            updateLoopMode(!mediaPlayerController.getLoopMode());
            mediaPlayerController.doToggleLoopMode();
        } else {
            //updateLoopMode(mediaPlayerController.getLoopMode()); // reset checkbox
            // HS dec 20006: do the same, it shouldn't matter whether the player is playing
            updateLoopMode(!mediaPlayerController.getLoopMode());
            mediaPlayerController.doToggleLoopMode();
        }
        */
    }

    private void updateLoopMode(boolean onOff) {
        ((ModePanel) mediaPlayerController.getModePanel()).updateLoopMode(onOff);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
