/*
 * File:     MergeTranscriptionsDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

import mpi.eudico.client.annotator.imports.MergeStep1;
import mpi.eudico.client.annotator.imports.MergeStep2;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;


/**
 * A Command that shows a merge transcriptions dialog.
 *
 * @author Han Sloetjes
 */
public class MergeTranscriptionsDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new linked files command.
     *
     * @param name the name of the command
     */
    public MergeTranscriptionsDlgCommand(String name) {
        commandName = name;
    }

    /**
     * Shows a multiple step dialog (wizard) to merge two transcriptions.
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the transcription
     * @param arguments the arguments: <ul><li>arg[0] = </li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl transcription = (TranscriptionImpl) receiver;

        MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());

        StepPane step1 = new MergeStep1(pane, transcription);
        StepPane step2 = new MergeStep2(pane);
        pane.addStep(step1);
        pane.addStep(step2);

        pane.createDialog(ELANCommandFactory.getRootFrame(transcription),
            ElanLocale.getString("MergeTranscriptionDialog.Title"), true)
            .setVisible(true);
    }

    /**
     * Returns the name of the command
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
