/*
 * File:     ModifyAnnotationDatCatDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.dcr.AnnotationDCRDialog;

import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;


/**
 * Creates a dialog to change the ISO Data Category reference of an annotation.
 *
 * @author Han Sloetjes
 */
public class ModifyAnnotationDatCatDlgCommand implements Command {
    private String commandName;

    /**
     * Constructor.
     *
     * @param commandName the name of the command
     */
    public ModifyAnnotationDatCatDlgCommand(String commandName) {
        super();
        this.commandName = commandName;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the active Annotation
     * @param arguments the arguments: arg[0]: the transcription
     */
    public void execute(Object receiver, Object[] arguments) {
        Annotation activeAnn = (Annotation) receiver;
        Transcription transcription = null;

        if (activeAnn instanceof AbstractAnnotation) {
            // create a dialog
            if ((arguments != null) && arguments[0] instanceof Transcription) {
                transcription = (Transcription) arguments[0];
            }

            AnnotationDCRDialog dialog = new AnnotationDCRDialog(ELANCommandFactory.getRootFrame(
                        transcription), true, transcription,
                    (AbstractAnnotation) activeAnn);
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getOwner());
            dialog.setVisible(true);
        }
    }

    /**
     * Returns the name
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
