/*
 * File:     PageSetupCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Preferences;

import mpi.eudico.server.corpora.clom.Transcription;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;


/**
 * Show a Page Setup dialog.
 *
 * @author Hennie Brugman
 * @author Han Sloetjes
 */
public class PageSetupCommand implements Command {
    private String commandName;

    /**
     * Creates a new PageSetupCommand instance
     *
     * @param name name of the command
     */
    public PageSetupCommand(String name) {
        commandName = name;
    }

    /**
     * Shows the dialog.
     *
     * @param receiver the transcription
     * @param arguments null
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription tr = (Transcription) receiver;
        PrinterJob printJob = PrintCommand.printJob;

        PageFormat pf = printJob.pageDialog(PrintCommand.pageFormat);
        PrintCommand.pageFormat = pf;

        // store in preferences
        Preferences.set("PageFormat.Height", pf.getHeight(), null);
        Preferences.set("PageFormat.Width", pf.getWidth(), null);
        Preferences.set("PageFormat.ImgX", pf.getImageableX(), null);
        Preferences.set("PageFormat.ImgY", pf.getImageableY(), null);
        Preferences.set("PageFormat.ImgHeight", pf.getImageableHeight(), null);
        Preferences.set("PageFormat.ImgWidth", pf.getImageableWidth(), null);
        Preferences.set("PageFormat.Orientation", pf.getOrientation(), null);
    }

    /**
     * Returns the name of the command.
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
