/*
 * File:     PasteAnnotationCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.util.AnnotationTransfer;

import java.awt.event.ActionEvent;


/**
 * A CommandAction to paste an annotation (i.e. a transferable AnnotationDataRecord) from the System's
 * Clipboard to a receiving transcription.
 *
 * Registration as MenuListener to the Menu for en/disabling the action is not sufficient since there
 * is an acceleration key. What is needed is to register a Clipboard listener, which is possible
 * in j2se 1.5 or higher.
 */
public class PasteAnnotationCA extends CommandAction {
    /**
     * Creates a new PasteAnnotationCA instance
     * @param viewerManager the ViewerManager
     */
    public PasteAnnotationCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.PASTE_ANNOTATION);
    }

    /**
     * Constructor to be called by subclasses; otherwise the coammandId will not be set properly.
     * @param viewerManager the viewer manager
     * @param name the name of the command
     */
    PasteAnnotationCA(ViewerManager2 viewerManager, String name) {
        super(viewerManager, name);
    }

    /**
     * @see mpi.eudico.client.annotator.commands.CommandAction#newCommand()
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.PASTE_ANNOTATION);
    }

    /**
     * @see mpi.eudico.client.annotator.commands.CommandAction#getReceiver()
     */
    protected Object getReceiver() {
        return vm.getTranscription();
    }

    /**
     * Don't create a command if there is no access to the clipboard.
     * Or if there is no or unusable contents on the clipboard.
     *
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent event) {
        if (!AnnotationTransfer.validContentsOnClipboard()) {
            return;
        }

        super.actionPerformed(event);
    }
}
