/*
 * File:     PreviousActiveTierCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;


/**
 * Sets the previous (up) tier active in MultiTierControlPanel.
 *
 * @author Han Sloetjes
 */
public class PreviousActiveTierCA extends CommandAction {
    /** Object array of size 1: Boolean.FALSE */
    final Object[] arguments = new Object[] { Boolean.FALSE };

    /**
     * Constructor.
     *
     * @param viewerManager the viewermanager
     */
    public PreviousActiveTierCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.PREVIOUS_ACTIVE_TIER);
    }

    /**
     * Creates a new ActiveTierCommand.
     *
     * @see mpi.eudico.client.annotator.commands.CommandAction#newCommand()
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.ACTIVE_TIER);
    }

    /**
     * Returns the receiver of the command.
     *
     * @return the MultiTierControlPanel
     */
    protected Object getReceiver() {
        return vm.getMultiTierControlPanel();
    }

    /**
     * Returns the arguments for the command.
     *
     * @return Boolean.TRUE
     */
    protected Object[] getArguments() {
        return arguments;
    }
}
