/*
 * File:     SaveSelectionAsEafCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;


/**
 * A command action that creates a command that saves annotations within the
 * selected time interval as eaf..
 *
 * @author Han Sloetjes
 */
public class SaveSelectionAsEafCA extends CommandAction
    implements SelectionListener {
    /**
     * @param viewerManager the viewermanager
     * @param name the name of the command
     */
    public SaveSelectionAsEafCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.SAVE_SELECTION_AS_EAF);
        viewerManager.connectListener(this);
    }

    /**
     * Creates a new <code>SaveSelectionAsEafCommand</code>.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SAVE_SELECTION_AS_EAF);
    }

    /**
     * The receiver of this CommandAction is the Transcription object
     *
     * @return the receiver
     */
    protected Object getReceiver() {
        return vm.getTranscription();
    }

    /**
     * Returns the arguments for the related Command.
     *
     * @return the arguments for the related Command
     */
    protected Object[] getArguments() {
        Object[] args = new Object[2];
        args[0] = new Long(vm.getSelection().getBeginTime());
        args[1] = new Long(vm.getSelection().getEndTime());

        return args;
    }

    /**
     * Disable the action if there is no selection.
     * @see mpi.eudico.client.annotator.SelectionListener#updateSelection()
     */
    public void updateSelection() {
        if (vm.getSelection().getBeginTime() != vm.getSelection().getEndTime()) {
            setEnabled(true);
        } else {
            setEnabled(false);
        }
    }
}
