/*
 * File:     SetAuthorCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.server.corpora.clom.Transcription;

import javax.swing.JOptionPane;


/**
 * A command that sets the author field of a document.
 * 
 * @author Han Sloetjes
 *
 */
public class SetAuthorCommand implements UndoableCommand {
    private String name;
    private Transcription transcription;
    private String oldAuthor;
    private String nextAuthor;

    /**
 * Constructor.
 * 
 * @param name the name
 */
    public SetAuthorCommand(String name) {
        this.name = name;
    }

    /**
 * Applies the new author name again.
 */
    public void redo() {
        if (transcription != null) {
            transcription.setAuthor(oldAuthor);
        }
    }

    /**
 * Restores the previous value of the author value.
 */
    public void undo() {
        if (transcription != null) {
            transcription.setAuthor(oldAuthor);
        }
    }

    /**
 * @param receiver the transcription
 * @param arguments null
 */
    public void execute(Object receiver, Object[] arguments) {
        if (receiver instanceof Transcription) {
            transcription = (Transcription) receiver;
        }

        if (transcription == null) {
            return;
        }

        oldAuthor = transcription.getAuthor();

        String input = (String) JOptionPane.showInputDialog(ELANCommandFactory.getRootFrame(
                    transcription),
                ElanLocale.getString("Frame.ElanFrame.SetAuthorMessage"),
                ElanLocale.getString("Menu.Edit.Author"),
                JOptionPane.PLAIN_MESSAGE, null, null, oldAuthor);

        if (input != null) {
            nextAuthor = input;
            transcription.setAuthor(nextAuthor);
            transcription.setChanged();
        }
    }

    /**
 * Returns the name of the command.
 * @return the name
 */
    public String getName() {
        return name;
    }
}
