/*
 * File:     SetBackupDelayCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;


/**
 * A Command to change the frequency of automatic backups.
 *
 * @author Han Sloetjes
 */
public class SetBackupDelayCommand implements Command {
    private String commandName;

    /**
     * Creates a new SetBackupDelayCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public SetBackupDelayCommand(String theName) {
        commandName = theName;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the BackupCA
     * @param arguments the arguments:  <ul><li>arg[0] = the delay for
     *        backup(Integer)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ((BackupCA) receiver).setDelay(((Integer) arguments[0]).intValue());
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
