/*
 * File:     SetMsPerFrameCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.player.ElanMediaPlayer;


/**
 * Command to manually set the video standard (of the media file) to PAL.<br>
 *
 * @author Han Sloetjes
 *
 * @see SetPAlCA
 */
public class SetMsPerFrameCommand implements Command {
    private String commandName;

    /**
     * Creates a new SetMsPerFrameCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public SetMsPerFrameCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the ElanMediaPlayer
     * @param arguments the arguments:  <ul><li>arg[0] = the new number of ms
     *        per frame (Long)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        long newValue = ((Long) arguments[0]).longValue();

        if (receiver != null) {
            ((ElanMediaPlayer) receiver).setMilliSecondsPerSample(newValue);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
