/*
 * File:     SetPALCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;


/**
 * CommandAction to manually set the video standard (of the media file) to PAL.<br>
 * This only influences the number of milliseconds per frame for Elan.<br>
 * PAL has 25 frames per second, resulting in 1000 / 25 = 40 milliseconds per
 * frame. See <a
 * href="http://archive.ncsa.uiuc.edu/SCMS/training/general/details/pal.html">NCSA
 * web site</a>.
 *
 * @author Han Sloetjes
 */
public class SetPALCA extends CommandAction {
    // the number of ms per frame

    /** Holds value of property DOCUMENT ME! */
    private final Object[] args = new Object[] { new Long(40L) };

    /**
     * Creates a new SetPALCA instance
     *
     * @param viewerManager DOCUMENT ME!
     */
    public SetPALCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.SET_PAL);
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SET_PAL);
    }

    /**
     * The receiver of this CommandAction is an ElanMediaPlayer.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getMasterMediaPlayer();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return args;
    }
}
