/*
 * File:     SyncModeCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;

import java.util.Enumeration;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;


/**
 * A command action that switches media synchronization mode on or off. By
 * default sync mode is off!
 *
 * @author Han Sloetjes
 */
public class SyncModeCA extends CommandAction {
    private ElanLayoutManager layoutManager;
    private boolean syncMode;

    /**
     * Creates a new SyncModeCA instance
     *
     * @param theVM DOCUMENT ME!
     * @param layoutManager DOCUMENT ME!
     */
    public SyncModeCA(ViewerManager2 theVM, ElanLayoutManager layoutManager) {
        super(theVM, ELANCommandFactory.SYNC_MODE);
        this.layoutManager = layoutManager;
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SYNC_MODE);
    }

    /**
     * The receiver of this CommandAction is the layoutManager.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return layoutManager;
    }

    /**
     * Argument[0] = Transcription, argument[1] = parent JFrame; needed for a
     * warning dialog when switching to sync mode.
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return new Object[] { vm.getTranscription() };
    }

    /**
     * Not very elegant way to reselect the JRadioMenuItem in case a switch to
     * a certain mode is not allowed. When more modi are added to
     * ElanLayoutManager the switch statement should adapted.
     *
     * @see ActionCommand#actionPerformed
     */
    public void actionPerformed(final ActionEvent event) {
        JRadioButtonMenuItem oldItem = null;
        JRadioButtonMenuItem item = null;
        int mode = layoutManager.getMode();

        if (event.getSource() instanceof JRadioButtonMenuItem) {
            item = (JRadioButtonMenuItem) event.getSource();

            if (item.getModel() instanceof JToggleButton.ToggleButtonModel) {
                ButtonGroup group = ((JToggleButton.ToggleButtonModel) item.getModel()).getGroup();
                Enumeration e = group.getElements();
elementloop: 
                while (e.hasMoreElements()) {
                    oldItem = (JRadioButtonMenuItem) e.nextElement();

                    switch (mode) {
                    case ElanLayoutManager.NORMAL_MODE:

                        if (oldItem.getAction() == ELANCommandFactory.getCommandAction(
                                    vm.getTranscription(),
                                    ELANCommandFactory.ANNOTATION_MODE)) {
                            break elementloop;
                        }

                        break;

                    default:
                        break;
                    }
                }
            }
        }

        super.actionPerformed(event);

        if (layoutManager.getMode() != ElanLayoutManager.SYNC_MODE) {
            if (oldItem != null) {
                oldItem.setSelected(true);
            }
        }
    }
}
