/*
 * File:     SyntaxViewerCommand.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;


/**
 * A Command that creates a Syntax viewer.
 *
 * @author
 */
public class SyntaxViewerCommand implements Command {
    /** Holds value of property DOCUMENT ME! */
    private static final String className = "mpi.syntax.elan.ElanSyntaxViewer";
    private String commandName;

    /**
     * Creates a new SyntaxViewerCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public SyntaxViewerCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static boolean isEnabled() {
        Object syntaxViewerClass = null;

        try {
            syntaxViewerClass = Class.forName(className);
        } catch (Exception e) {
        }

        return (syntaxViewerClass != null);
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver null
     * @param arguments the arguments:  <ul><li>arg[0] = the Transcription
     *        object(Transcription)</li> <li>arg[1] = the ViewerManager
     *        (ViewerManager)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ((ViewerManager2) arguments[1]).createViewer(className, 100);
    }

    /**
     * Returns the name of the command
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
