/*
 * File:     TierDependenciesCA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.EscCloseAction;

import mpi.eudico.client.util.TierTree;

import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

import mpi.eudico.server.corpora.util.ACMEditableDocument;

import mpi.util.gui.TreeFrame;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;


/**
 *
 */
public class TierDependenciesCA extends CommandAction implements ACMEditListener {
    private JFrame dependencyFrame;
    private int locationX = -1;
    private int locationY = -1;
    private int sizeWidth = -1;
    private int sizeHeight = -1;

    /**
     * Creates a new TierDependenciesCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public TierDependenciesCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.TIER_DEPENDENCIES);

        try {
            ((ACMEditableDocument) vm.getTranscription()).addACMEditListener((ACMEditListener) this);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.TIER_DEPENDENCIES);
    }

    /**
     *
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * Returns null, no arguments need to be passed.
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        Object[] args = new Object[1];
        args[0] = getDependencyFrame();

        return args;
    }

    /**
     * Give access to the frame.
     * @return the dependency frame or null
     */
    public JFrame getFrame() {
        return dependencyFrame;
    }

    private JFrame getDependencyFrame() {
        if (dependencyFrame == null) {
            createDependencyFrame();
        }

        return dependencyFrame;
    }

    private void createDependencyFrame() {
        try {
            dependencyFrame = new TreeFrame(new TierTree(vm.getTranscription()).getTree(),
                    false);

            ((TreeFrame) dependencyFrame).setTreeBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            dependencyFrame.setTitle(ElanLocale.getString("Tier Dependencies"));

            if ((locationX != -1) && (locationY != -1) && (sizeWidth != -1) &&
                    (sizeHeight != -1)) {
                dependencyFrame.setLocation(locationX, locationY);
                dependencyFrame.setSize(sizeWidth, sizeHeight);
            }

            if ((dependencyFrame.getHeight() < 100) ||
                    (dependencyFrame.getWidth() < 133)) {
                dependencyFrame.setSize(133, 200);
            }

            addCloseActions();

            updateLocale();
        } catch (Exception ex) {
            System.out.println("Couldn't create dependencyFrame.");
            ex.printStackTrace();
        }
    }

    //needed to set title of dialog
    public void updateLocale() {
        super.updateLocale();

        if (dependencyFrame != null) {
            dependencyFrame.setTitle(ElanLocale.getString(
                    "Menu.View.DependenciesDialog"));
            dependencyFrame.repaint();
        }
    }

    /**
     * Add the Escape and Ctrl-W close actions.
     */
    protected void addCloseActions() {
        if (dependencyFrame != null) {
            EscCloseAction escAction = new EscCloseAction(dependencyFrame);
            CtrlWCloseAction wAction = new CtrlWCloseAction(dependencyFrame);

            InputMap inputMap = dependencyFrame.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
            ActionMap actionMap = dependencyFrame.getRootPane().getActionMap();

            if (inputMap instanceof ComponentInputMap && (actionMap != null)) {
                String esc = "esc";
                inputMap.put((KeyStroke) escAction.getValue(
                        Action.ACCELERATOR_KEY), esc);
                actionMap.put(esc, escAction);

                String wcl = "cw";
                inputMap.put((KeyStroke) wAction.getValue(
                        Action.ACCELERATOR_KEY), wcl);
                actionMap.put(wcl, wAction);
            }

            dependencyFrame.addWindowListener(new WindowAdapter() {
                    public void windowClosing(WindowEvent e) {
                        ((ACMEditableDocument) vm.getTranscription()).removeACMEditListener((ACMEditListener) TierDependenciesCA.this);
                    }
                });
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param e DOCUMENT ME!
     */
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
        case ACMEditEvent.ADD_TIER:
        case ACMEditEvent.REMOVE_TIER:
        case ACMEditEvent.CHANGE_TIER: {
            if (dependencyFrame == null) {
                break;
            }

            boolean bVisible = dependencyFrame.isVisible();

            //remember last position before disposing
            locationX = (int) dependencyFrame.getLocation().getX();
            locationY = (int) dependencyFrame.getLocation().getY();
            sizeWidth = (int) dependencyFrame.getSize().getWidth();
            sizeHeight = (int) dependencyFrame.getSize().getHeight();

            dependencyFrame.dispose();

            //update tree
            createDependencyFrame();

            //if tree was visible before updating, show it again
            if ((command != null) && (bVisible == true)) {
                command.execute(getReceiver(), getArguments());
            }
        }
        }
    }
}
