/*
 * File:     AboutMA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.AboutPanel;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;


/**
 * Menu action that shows the About box.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class AboutMA extends FrameMenuAction {
    /**
     * Creates a new AboutMA instance
     *
     * @param name name of the action
     * @param frame the parent frame
     */
    public AboutMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    /**
     * Shows an ELAN About message pane.
     *
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(frame, new AboutPanel(),
            ElanLocale.getString("Menu.Help.AboutDialog"),
            JOptionPane.PLAIN_MESSAGE, null);
    }
}
