/*
 * File:     EditLocalDCRMA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;

import mpi.eudico.client.annotator.dcr.ELANDCRDialog;

import java.awt.event.ActionEvent;


/**
 * A menu action that creates a dialog to edit the locally stored ISO 12620
 * Data Category selection.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class EditLocalDCRMA extends FrameMenuAction {
    /**
     * Creates a new EditLocalDCRMA instance
     *
     * @param name name of the action
     * @param frame the parent Elan frame
     */
    public EditLocalDCRMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    /**
     * @see mpi.eudico.client.annotator.commands.global.MenuAction#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {
        ELANDCRDialog dialog = new ELANDCRDialog(frame, true,
                ELANDCRDialog.LOCAL_MODE);
        dialog.pack();
        dialog.setVisible(true);
    }
}
