/*
 * File:     ExitMA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.FrameManager;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * Action that starts the Exit Application sequence.
 *
 * @author Han Sloetjes, MPI
 */
public class ExitMA extends MenuAction {
    /**
     * Creates a new ExitMA instance.
     *
     * @param name the name of the action (command)
     */
    public ExitMA(String name) {
        super(name);
    }

    /**
     * Invokes exit on the FrameManager.
     *
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
        FrameManager.getInstance().exit();
    }
}
