/*
 * File:     ExportWordsMultiMA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.export.ExportWordListDialog;

import java.awt.event.ActionEvent;

import java.util.ArrayList;


/**
 * Creates a dialog to select tiers from multiple files for a word list export.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class ExportWordsMultiMA extends AbstractProcessMultiMA {
    /**
     * Creates a new ExportWordsMultiMA instance
     *
     * @param name name of the action
     * @param frame the containing frame
     */
    public ExportWordsMultiMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    /**
     * Creates a <code>{@link ExportWordListDialog}</code>
     *
     * @param e the event!
     */
    public void actionPerformed(ActionEvent e) {
        ArrayList files = getMultipleFiles(frame,
                ElanLocale.getString("ExportDialog.WordList.Title"));

        if ((files == null) || (files.size() == 0)) {
            return;
        }

        // create a exportwordlistdialog with these files to allow tier selection
        new ExportWordListDialog(frame, true, files).setVisible(true);
    }
}
