package mpi.eudico.client.annotator.commands.global;

import mpi.util.FontBrowser.FontGui;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.WindowConstants;


/**
 * Menu action that creates a Font Browser window.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class FontBrowserMA extends MenuAction {
    private FontGui browser = null;

    /**
     * Creates a new FontBrowserMA instance
     *
     * @param name the name of the action
     */
    public FontBrowserMA(String name) {
        super(name);
    }

    /**
     * Creates the browser if it does not exist or brings it to front if it is
     * already created.
     *
     * @see mpi.eudico.client.annotator.commands.global.MenuAction#actionPerformed(java.awt.event.ActionEvent)
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (browser == null) {
            browser = new FontGui();

            // remove the default window listeners, one of them calls System.exit
            WindowListener[] wl = browser.getWindowListeners();

            for (int i = 0; i < wl.length; i++) {
                browser.removeWindowListener(wl[i]);
            }

            browser.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

            // add a window listener that nullifies the browser member when
            // the font browser window is closed
            browser.addWindowListener(new WindowAdapter() {
                    public void windowClosed(WindowEvent e) {
                        FontBrowserMA.this.browser.removeWindowListener(this); //??
                        FontBrowserMA.this.browser = null;
                    }
                });
            browser.setVisible(true);
        } else {
            browser.setVisible(true);
            browser.toFront();
        }
    }
}
