/*
 * File:     MultiEAFScrubberMA.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.util.ClientLogger;

import mpi.eudico.client.util.TranscriptionScrubber;

import java.awt.event.ActionEvent;

import java.util.ArrayList;


/**
 * A class that creates a thread that iterates over all annotations of the eaf
 * files  in the list and removes leading and trailing whitespaces and ASCII
 * control characters. If anything changed the transcription is saved again.
 * By default the file is overwritten.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class MultiEAFScrubberMA extends AbstractProcessMultiMA
    implements ClientLogger {
    /**
     * Creates a new MultiEAFScrubberMA instance
     *
     * @param name the name
     * @param frame the frame
     */
    public MultiEAFScrubberMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    /**
     * Creates a thread to remove leading and trailing spaces and ASCII control
     * characters from annotations.
     *
     * @param e the event
     */
    public void actionPerformed(ActionEvent e) {
        ArrayList files = getMultipleFiles(frame,
                ElanLocale.getString("ExportDialog.AnnotationList.Title"));

        if ((files == null) || (files.size() == 0)) {
            LOG.info("No (valid) files supplied.");

            return;
        }

        TranscriptionScrubber scrubber = new TranscriptionScrubber();
        scrubber.scrubAndSave(files);
    }
}
