package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.export.ShortCutPrinter;

import mpi.eudico.client.annotator.gui.ClosableFrame;

import mpi.eudico.client.util.SubHeaderTableCellRenderer;
import mpi.eudico.client.util.TableSubHeaderObject;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.WindowConstants;
import javax.swing.table.DefaultTableModel;


/**
 * A menu action that creates and fills a table showing the current 
 * keyboard shortcut bindings. 
 * 
 * @author Han Sloetjes
 * @version 1.0
  */
public class ShortcutsMA extends MenuAction {
    private JFrame shortcutsFrame;
    private JTable tableShortcuts;
    private JButton printButton;
    private DefaultTableModel model;

    /**
     * Creates a new ShortcutsMA instance
     *
     * @param name the name of the action
     */
    public ShortcutsMA(String name) {
        super(name);
    }

    /**
     * @see mpi.eudico.client.annotator.commands.global.MenuAction#actionPerformed(java.awt.event.ActionEvent)
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == printButton) {
            new ShortCutPrinter(tableShortcuts).startPrint();
            return;
        }
        if (shortcutsFrame == null) {
            shortcutsFrame = new ClosableFrame("Shortcuts");
            shortcutsFrame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
            // replaced by Shortcut utils, in updateLocale
            model = new DefaultTableModel(0, 2);
            tableShortcuts = new JTable(model);
            tableShortcuts.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            tableShortcuts.setPreferredScrollableViewportSize(new Dimension(
                    500, 600));
            tableShortcuts.setShowVerticalLines(false);
            tableShortcuts.getTableHeader().setReorderingAllowed(false);
            tableShortcuts.setEnabled(false);

            tableShortcuts.getColumnModel().getColumn(0).setPreferredWidth(200);
            tableShortcuts.getColumnModel().getColumn(1).setPreferredWidth(300);

            tableShortcuts.setDefaultRenderer(Object.class,
                new SubHeaderTableCellRenderer());

            for (int i = 0; i < tableShortcuts.getRowCount(); i++) {
                if (tableShortcuts.getValueAt(i, 0) instanceof TableSubHeaderObject) {
                    tableShortcuts.setRowHeight(i,
                        tableShortcuts.getRowHeight() + 6);
                }
            }

            JScrollPane listScrollPane = new JScrollPane(tableShortcuts);

            shortcutsFrame.getContentPane().setLayout(new GridBagLayout());

            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 4, 2);
            gbc.fill = GridBagConstraints.BOTH;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            shortcutsFrame.getContentPane().add(listScrollPane, gbc);

            printButton = new JButton();
            printButton.addActionListener(this);
            gbc.gridy = 1;
            gbc.weightx = 0;
            gbc.weighty = 0;
            gbc.fill = GridBagConstraints.NONE;
            gbc.anchor = GridBagConstraints.CENTER;
            shortcutsFrame.getContentPane().add(printButton, gbc);

            updateLocale();

            shortcutsFrame.pack();
            shortcutsFrame.setVisible(true);
            shortcutsFrame.addWindowListener(new CloseListener());
        } else {
            shortcutsFrame.setVisible(true);
            shortcutsFrame.setState(JFrame.NORMAL);
            shortcutsFrame.toFront();
        }
    }

    /**
     * Updates shortcut labels and column headers.
     */
    public void updateLocale() {
        super.updateLocale();

        if (tableShortcuts != null) {
            tableShortcuts.getColumnModel().getColumn(0)
                          .setHeaderValue(ElanLocale.getString(
                    "Frame.ShortcutFrame.ColumnShortcut"));
            tableShortcuts.getColumnModel().getColumn(1)
                          .setHeaderValue(ElanLocale.getString(
                    "Frame.ShortcutFrame.ColumnDescription"));
            printButton.setText(ElanLocale.getString("Menu.File.Print"));

            // replace by ShortCutUtils
            model.setRowCount(0);

            Map<String, List<String>> curShorts = ShortcutsUtil.getInstance()
                                                               .getShortcuttableActions();

            Iterator<Map.Entry<String, List<String>>> csIt = curShorts.entrySet()
                                                                      .iterator();
            String key;
            String shortcutId;
            KeyStroke stroke;
            List<String> ids;

            while (csIt.hasNext()) {
                key = csIt.next().getKey();
                model.addRow(new Object[] {
                        new TableSubHeaderObject(ElanLocale.getString(key)),
                        new TableSubHeaderObject(null)
                    });
                ids = curShorts.get(key);

                for (int i = 0; i < ids.size(); i++) {
                    shortcutId = ids.get(i);
                    stroke = ShortcutsUtil.getInstance()
                                          .getKeyStrokeForAction(shortcutId);

                    if (stroke != null) { // only show the actions with a shortcut in this table
                        model.addRow(new Object[] {
                                ShortcutsUtil.getInstance()
                                             .getDescriptionForKeyStroke(stroke),
                                ShortcutsUtil.getInstance()
                                             .getDescriptionForAction(shortcutId)
                            });
                    }
                }
            }

            shortcutsFrame.setTitle(ElanLocale.getString(
                    "Menu.View.ShortcutsDialog"));
            shortcutsFrame.repaint(); //if tableShortcuts != null, then shortcutsFrame != null too
        }
    }

    //#####################################################
    /**
     * Listener for closing events.
     * 
     * @author Han Sloetjes	
     * @version 1.0
      */
    private class CloseListener extends WindowAdapter {
        /**
         * If the shortcut frame is closed, set it to null.
         *
         * @see java.awt.event.WindowAdapter#windowClosed(java.awt.event.WindowEvent)
         */
        @Override
        public void windowClosed(WindowEvent e) {
            shortcutsFrame.removeWindowListener(this);
            shortcutsFrame = null;
        }
    }
}
