/*
 * File:     LocalDCSPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.dcr;

import mpi.dcr.ILATDCRConnector;
import mpi.dcr.LocalDCSelectPanel;

import java.util.List;
import java.util.ResourceBundle;

import javax.swing.JDialog;
import javax.swing.JFrame;


/**
 * A panel for data category selection from a local cache.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class LocalDCSPanel extends LocalDCSelectPanel {
    /**
     * Creates a new LocalDCSPanel instance
     *
     * @param connector the local connector
     */
    public LocalDCSPanel(ILATDCRConnector connector) {
        super(connector);
    }

    /**
     * Creates a new LocalDCSPanel instance
     *
     * @param connector the connector
     * @param resBundle a resource bundle with localized strings
     */
    public LocalDCSPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
    }

    /**
     * Creates a new LocalDCSPanel instance
     */
    public LocalDCSPanel() {
        super();
    }

    /**
     * @see mpi.dcr.LocalDCSelectPanel#selectAndAddCategories()
     */
    protected void selectAndAddCategories() {
        ELANDCRDialog dialog = null;

        if (this.getTopLevelAncestor() instanceof JDialog) {
            dialog = new ELANDCRDialog((JDialog) this.getTopLevelAncestor(),
                    true, ELANDCRDialog.REMOTE_MODE);
        } else {
            dialog = new ELANDCRDialog((JFrame) this.getTopLevelAncestor(),
                    true, ELANDCRDialog.REMOTE_MODE);
        }

        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true); // blocks

        Object val = dialog.getValue();

        if (val instanceof List) {
            addCategories((List) val);
        }
    }
}
