/*
 * File:     AbstractEditableGridViewer.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.grid;

import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

import java.util.List;


/**
 * This class makes the GridViewer editable and let him responds to changes in
 * ACM elsewhere
 * @version Aug 2005 Identity removed
 */
abstract public class AbstractEditableGridViewer extends AbstractGridViewer
    implements ACMEditListener {
    /** Holds value of property DOCUMENT ME! */
    protected GridEditor gridEditor;

    /**
     * Constructor
     *
     */
    public AbstractEditableGridViewer(AnnotationTable table) {
        super(table);
    }

    /**
     * DOCUMENT ME!
     */
    protected void initTable() {
        super.initTable();
        gridEditor = new GridEditor(this, dataModel);
        table.setDefaultEditor(Object.class, gridEditor);
    }

    /**
     * Update method from ActiveAnnotationUser.
     */
    public void updateActiveAnnotation() {
        if (dataModel.getRowCount() == 0) {
            return;
        }

        repaint();

        if (getActiveAnnotation() != null) {
            doUpdate();
        }
    }

    /**
     * Checks the kind of edit that has happened and updates the table when
     * necessary.
     *
     * @param e
     *            the ACMEditEvent
     */
    public void ACMEdited(ACMEditEvent e) {
        if (dataModel.getRowCount() == 0) {
            return;
        }

        switch (e.getOperation()) {
        case ACMEditEvent.CHANGE_ANNOTATION_TIME:
            repaint();

            break;

        case ACMEditEvent.CHANGE_ANNOTATION_VALUE:
            repaint();

            break;

        default:
            repaint();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param annotations DOCUMENT ME!
     */
    protected void updateDataModel(List annotations) {
        gridEditor.cancelCellEditing();

        if (annotations != null) {
            dataModel.updateAnnotations(annotations);
        }
    }

    /**
     * method from ElanLocaleListener not implemented in AbstractViewer
     */
    public void updateLocale() {
        gridEditor.updateLocale();
        super.updateLocale();
    }

    /**
     *
     */
    public void preferencesChanged() {
        // method stub		
    }
}
