/*
 * File:     AboutPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui;

import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ElanLocale;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;


/**
 * A panel with a tabpane, containing a tab for general information
 * and a tab for acknowledgments (developers and translators).
 *
 * @author Han Sloetjes
 * @version 1.0
  */
public class AboutPanel extends JPanel {
    private JTabbedPane tabPane;
    private JPanel aboutTabPanel;
    private JPanel acknowledgeTabPanel;

    /**
     * Creates a new AboutPanel instance
     */
    public AboutPanel() {
        super();
        initPanel();
    }

    private void initPanel() {
        setLayout(new GridBagLayout());
        tabPane = new JTabbedPane();
        aboutTabPanel = new JPanel(new GridBagLayout());

        Icon icon = null;

        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN256.png"));
        } catch (Exception ex) {
        }

        StringBuffer textBuf = new StringBuffer("<html>");
        textBuf.append("<b>");
        textBuf.append("E L A N - ELAN Linguistic Annotator");
        textBuf.append("<br>");
        textBuf.append("Version: ");
        textBuf.append(ELAN.getVersionString());
        textBuf.append("<br><br>");
        textBuf.append("Copyright \u00A9 2001 - 2009");
        textBuf.append("<br>");
        textBuf.append("Max-Planck-Institute for Psycholinguistics");
        textBuf.append("<br>");
        textBuf.append("Nijmegen, The Netherlands");
        textBuf.append("</b><br><br><br>");
        textBuf.append(ElanLocale.getString("Menu.Help.AboutText.GPL"));
        textBuf.append("<br>");
        textBuf.append("</html>");

        JLabel label = new JLabel(textBuf.toString().replaceAll("\\u000A",
                    "<br>"));
        label.setFont(label.getFont().deriveFont(Font.PLAIN));

        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        if (icon != null) {
            aboutTabPanel.add(new JLabel(icon), gbc);
        }

        gbc.gridx = 1;
        gbc.anchor = GridBagConstraints.CENTER;
        aboutTabPanel.add(label, gbc);

        tabPane.addTab(ElanLocale.getString("Menu.Help.About"), aboutTabPanel);

        gbc.gridx = 0;
        add(tabPane, gbc);

        acknowledgeTabPanel = new JPanel(new GridBagLayout());

        JTabbedPane acknowTabPane = new JTabbedPane();
        JScrollPane devScrollPane = new JScrollPane(getDeveloperTable());
        devScrollPane.setPreferredSize(new Dimension(200, 80));
        acknowTabPane.addTab(ElanLocale.getString("AboutDialog.Source"),
            devScrollPane);

        JScrollPane transScrollPane = new JScrollPane(getTranslatorsTable());
        transScrollPane.setPreferredSize(new Dimension(200, 80));
        acknowTabPane.addTab(ElanLocale.getString("AboutDialog.Translations"),
            transScrollPane);

        gbc.fill = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        acknowledgeTabPanel.add(acknowTabPane, gbc);
        tabPane.addTab(ElanLocale.getString("AboutDialog.Acknowledgments"),
            acknowledgeTabPanel);
    }

    private JTable getDeveloperTable() {
        DefaultTableModel model = new DefaultTableModel(0, 0);
        model.addColumn(ElanLocale.getString("AboutDialog.Name"));
        model.addColumn(ElanLocale.getString("AboutDialog.Affiliation"));
        model.addRow(new String[] { "Eric Auer", "MPI" });
        model.addRow(new String[] { "Hennie Brugman", "MPI" });
        model.addRow(new String[] { "Greg Gulrajani", "MPI" });
        model.addRow(new String[] { "Alex Klassmann", "MPI" });
        model.addRow(new String[] { "Alex K\u00f6nig", "MPI" });
        model.addRow(new String[] { "Markus Kramer", "MPI" });
        model.addRow(new String[] { "Marc Pippel", "MPI" });
        model.addRow(new String[] { "Albert Russel", "MPI" });
        model.addRow(new String[] { "Han Sloetjes", "MPI" });
        model.addRow(new String[] { "Harriet Spenke", "MPI" });
        model.addRow(new String[] { "", "" });
        model.addRow(new String[] { "SIDGrid team", "SIDGrid, Chicago" });
        model.addRow(new String[] { "Ouriel Grynzspan", "CNRS, Paris" }); //H\\u00f4pital de La Salp\\u00e8tri\\u00e8re,
        model.addRow(new String[] {
                "Mark Blokpoel", "Radboud University, Nijmegen"
            });
        model.addRow(new String[] { "Martin Schickbichler", "TU Graz" });
        model.addRow(new String[] {
                "Tom Myers, Consultant, and the Research Staff",
                "NSF Project \"Five Languages of Eurasia\""
            });

        JTable table = new JTable(model);
        table.getTableHeader().setReorderingAllowed(false);

        return table;
    }

    private JTable getTranslatorsTable() {
        DefaultTableModel model = new DefaultTableModel(0, 0);
        model.addColumn(ElanLocale.getString("AboutDialog.Name"));
        model.addColumn(ElanLocale.getString("Menu.Options.Language"));

        model.addRow(new String[] { "Gemma Barbera", "Catalan, Spanish" });
        model.addRow(new String[] { "Florian Gu\u00e9niot", "French" });
        model.addRow(new String[] { "Alexander Koenig", "German" });
        model.addRow(new String[] { "Alex Klassmann", "German" });
        model.addRow(new String[] { "Tarc\u00edsio Leite", "Portuguese" });
        model.addRow(new String[] { "Johanna Mesch", "Swedish" });
        model.addRow(new String[] { "Josep Quer ", "Catalan, Spanish" });
        model.addRow(new String[] { "Andresa Furtado Schmitz", "Portuguese" });
        model.addRow(new String[] { "Yuki Yamada", "Japanese" });

        JTable table = new JTable(model);
        table.getTableHeader().setReorderingAllowed(false);

        return table;
    }
}
