/*
 * File:     AbstractStatisticsPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;


/**
 * An abstract panel class for a statistics table and related gui elements.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public abstract class AbstractStatisticsPanel extends JPanel {
    /** the transcription */
    protected TranscriptionImpl transcription;

    /** the total (media) duration */
    protected long totalDuration;

    //Statistics table GUI 

    /** the scrollpane for the table */
    protected JScrollPane statPane;

    /** the panel for the table */
    protected JPanel statPanel;

    /** the statistics table */
    protected JTable statTable;

    /** no selection */
    protected final String EMPTY = "-";

    /**
     * Creates a new AbstractStatisticsPanel instance
     *
     * @param transcription the transcription
     */
    public AbstractStatisticsPanel(Transcription transcription) {
        super();
        this.transcription = (TranscriptionImpl) transcription;
        initComponents();
    }

    /**
     * Creates a new AbstractStatisticsPanel instance
     *
     * @param transcription the transcription
     * @param totalDuration the duration
     */
    public AbstractStatisticsPanel(Transcription transcription,
        long totalDuration) {
        super();
        this.transcription = (TranscriptionImpl) transcription;
        this.totalDuration = totalDuration;
    }

    /**
     * initialise ui elements and create the initial table
     */
    abstract void initComponents();

    /**
     * Returns the current table.
     *
     * @return the current statistics table
     */
    public abstract JTable getStatisticsTable();
}
