/*
 * File:     ClosableFrame.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui;

import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;


/**
 * A frame with registered actions to close (dispose) the frame with the Escape
 * or  Ctrl-W (Command-W) key events.
 */
public class ClosableFrame extends JFrame {
    /**
     * Constructor.
     *
     * @throws HeadlessException
     */
    public ClosableFrame() throws HeadlessException {
        super();
        addCloseActions();
    }

    /**
     * Constructor.
     *
     * @param gc
     */
    public ClosableFrame(GraphicsConfiguration gc) {
        super(gc);
        addCloseActions();
    }

    /**
     * Constructor.
     *
     * @param title
     *
     * @throws HeadlessException
     */
    public ClosableFrame(String title) throws HeadlessException {
        super(title);
        addCloseActions();
    }

    /**
     * Constructor.
     *
     * @param title the title
     * @param gc
     */
    public ClosableFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        addCloseActions();
    }

    /**
     * Add the Escape and Ctrl-W close actions.
     */
    protected void addCloseActions() {
        EscCloseAction escAction = new EscCloseAction(this);
        CtrlWCloseAction wAction = new CtrlWCloseAction(this);

        InputMap inputMap = getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
        ActionMap actionMap = getRootPane().getActionMap();

        if (inputMap instanceof ComponentInputMap && (actionMap != null)) {
            String esc = "esc";
            inputMap.put((KeyStroke) escAction.getValue(Action.ACCELERATOR_KEY),
                esc);
            actionMap.put(esc, escAction);

            String wcl = "cw";
            inputMap.put((KeyStroke) wAction.getValue(Action.ACCELERATOR_KEY),
                wcl);
            actionMap.put(wcl, wAction);
        }
    }
}
