/*
 * File:     ColumnSorter.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui;

import java.util.Comparator;
import java.util.Vector;


/**
 * 
 * @author alekoe
 * 
 * a helper class for sorting columns of a table
 */
class ColumnSorter implements Comparator {
    /** Holds value of property DOCUMENT ME! */
    int colIndex;

    /**
     * Creates a new ColumnSorter instance
     *
     * @param colIndex DOCUMENT ME!
     */
    ColumnSorter(int colIndex) {
        this.colIndex = colIndex;
    }

    /**
 * a method to compare two input vectors for sorting purposes
 * 
 * @param a first input vector
 * @param b second input vector
 * 
 * @return     less than 0 if a should go before b
 *             more than 0 if b should go before a
 *             0 if both are equal and order between them doesn't matter 
 */
    public int compare(Object a, Object b) {
        Vector v1 = (Vector) a;
        Vector v2 = (Vector) b;
        Object o1 = v1.get(colIndex);
        Object o2 = v2.get(colIndex);

        if (o1 instanceof String && (((String) o1).length() == 0)) {
            o1 = null;
        }

        if (o2 instanceof String && (((String) o2).length() == 0)) {
            o2 = null;
        }

        if ((o1 == null) && (o2 == null)) {
            return 0;
        } else if (o1 == null) {
            return 1;
        } else if (o2 == null) {
            return -1;
        } else if (o1 instanceof Comparable) {
            return ((Comparable) o1).compareTo(o2);
        } else {
            return o1.toString().compareTo(o2.toString());
        }
    }
}
