/*
 * File:     LayoutableTestComponent.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JButton;
import javax.swing.JComponent;


/**
 * DOCUMENT ME!
 * $Id: LayoutableTestComponent.java 4129 2005-08-03 15:01:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class LayoutableTestComponent extends JComponent implements Layoutable {
    private boolean bWantsAllAvailableSpace = false;
    private boolean bIsOptional = false;
    private boolean bIsDetachable = false;
    private boolean bIsHorizontallyResizable = false;
    private boolean bIsVerticallyResizable = false;
    private int imageOffset = 0;
    private int minimalWidth = 0;
    private int minimalHeight = 0;
    private int nr;
    private Color color;

    /**
     * Creates a new LayoutableTestComponent instance
     *
     * @param nr DOCUMENT ME!
     * @param color DOCUMENT ME!
     */
    LayoutableTestComponent(int nr, Color color) {
        this.nr = nr;
        this.color = color;

        setBackground(color);

        JButton but = new JButton("" + nr);
        but.setBackground(color);
        but.setSize(getMinimalWidth(), getMinimalHeight());

        setLayout(new BorderLayout());
        add(but, BorderLayout.CENTER);
    }

    // uses all free space in horizontal direction
    public boolean wantsAllAvailableSpace() {
        if ((nr == 7) || (nr == 8)) {
            return true;
        } else {
            return false;
        }
    }

    // can be shown/hidden. If hidden, dimensions are (0,0), position in layout is kept
    public boolean isOptional() {
        return false;
    }

    // can be detached, re-attached from main document window
    public boolean isDetachable() {
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isWidthChangeable() {
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isHeightChangeable() {
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getMinimalWidth() {
        return 50;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getMinimalHeight() {
        return 50;
    }

    // position of image wrt Layoutable's origin, to be used for spatial alignment
    public int getImageOffset() {
        return 10;
    }
}
