/*
 * File:     StepTitlePanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui.multistep;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * StepTitlePanel. The top panel of the multistep pane, displaying the
 * title (short description) of the active or current step.
 *
 * @author Han Sloetjes
 */
public class StepTitlePanel extends JPanel {
    private JLabel titleLabel;

    /**
     * Creates a new StepTitlePanel instance.
     */
    public StepTitlePanel() {
        super();
        initComponents();
    }

    private void initComponents() {
        setLayout(new GridBagLayout());

        Insets insets = new Insets(4, 10, 4, 4);

        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        titleLabel = new JLabel();
        add(titleLabel, gridBagConstraints);
    }

    /**
     * Sets the Label's text, the title of the step.
     *
     * @param text the title
     */
    public void setTitleText(String text) {
        titleLabel.setText("<html>" + text + "</html>");
    }
}
