/*
 * File:     HelpException.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.help;


/**
 * An exception thrown when the help window can not be created, for whatever
 * reason.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class HelpException extends Exception {
    /**
     * Creates a new HelpException instance
     */
    public HelpException() {
        super();
    }

    /**
     * Creates a new HelpException instance
     *
     * @param message exception message
     */
    public HelpException(String message) {
        super(message);
    }

    /**
     * Creates a new HelpException instance
     *
     * @param message exception message
     * @param cause the cause
     */
    public HelpException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new HelpException instance
     *
     * @param cause the cause
     */
    public HelpException(Throwable cause) {
        super(cause);
    }
}
