/*
 * File:     MDConfigurationDialog.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.md;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.ClosableDialog;

import mpi.eudico.client.annotator.md.spi.MDConfigurationPanel;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;


/**
 * Shows a configuration panel for metadata configuration.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class MDConfigurationDialog extends ClosableDialog
    implements ActionListener {
    private MDConfigurationPanel panel;
    private JButton applyButton;
    private JButton cancelButton;

    /**
     * Creates a new MDConfigurationDialog instance
     *
     *@param owner the parent
     * @param panel the config panel
     *
     * @throws HeadlessException
     */
    public MDConfigurationDialog(Frame owner, MDConfigurationPanel panel)
        throws HeadlessException {
        super(owner);
        this.panel = panel;
        setModal(true);
        setTitle(ElanLocale.getString("MetadataViewer.Configure"));
        initComponents();
    }

    private void initComponents() {
        getContentPane().setLayout(new GridBagLayout());

        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 4));

        applyButton = new JButton(ElanLocale.getString("Button.Apply"));
        applyButton.addActionListener(this);
        buttonPanel.add(applyButton);
        cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);

        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        getContentPane().add(panel, gbc);

        gbc.fill = GridBagConstraints.NONE;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        getContentPane().add(buttonPanel, gbc);

        pack();
        setLocationRelativeTo(getParent());
    }

    /**
     * The action performed event handling.
     *
     * @param ae the action event
     */
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == cancelButton) {
            setVisible(false);
            dispose();
        } else if (ae.getSource() == applyButton) {
            panel.applyChanges();
            setVisible(false);
            dispose();
        }
    }
}
