/*
 * File:     ImdiConstants.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.md.imdi;


/**
 * A limited set of IMDI constants.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public interface ImdiConstants {
    /** property METATRANSCRIPT */
    public static final String METATRANSCRIPT = "METATRANSCRIPT";

    /** property MDGroup */
    public static final String MDGROUP = "MDGroup";

    /** property SESSION */
    public static final String SESSION = "Session";

    /** property PROJECT */
    public static final String PROJECT = "Project";

    /** property KEYS */
    public static final String KEYS = "Keys";

    /** property KEY */
    public static final String KEY = "Key";

    /** property CONTENT */
    public static final String CONTENT = "Content";

    /** property ACTORS */
    public static final String ACTORS = "Actors";

    /** property ACTOR */
    public static final String ACTOR = "Actor";

    /** property RESOURCES */
    public static final String RESOURCES = "Resources";

    /** moets important container elements */
    public static final String[] CONTAINERS = new String[] {
            METATRANSCRIPT, MDGROUP, SESSION, KEYS, CONTENT, ACTORS, RESOURCES
        };
}
