/*
 * File:     MDViewerComponent.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.md.spi;

import java.util.Map;
import java.util.ResourceBundle;


/**
 * An interface for a component for visualisation of metadata keys and values.
 * Implementers must extend a java.awt.Component that can be added to a
 * scrollpane.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public interface MDViewerComponent {
    /**
     * Sets the metadata service provider.
     *
     * @param provider the metadata service provider
     */
    public void setProvider(MDServiceProvider provider);

    /**
     * Sets the selected keys and values. May be ignored.
     *
     * @param keysAndValuesMap a map containing key-value pairs
     */
    public abstract void setSelectedKeysAndValues(Map keysAndValuesMap);

    /**
     * Provides a bundle containing strings for ui elements.
     *
     * @param bundle locale resource bundle
     */
    public void setResourceBundle(ResourceBundle bundle);
}
