/*
 * File:     MultiSourcePlayer.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.player;

import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;


/**
 * Describes a Player that can refer to and select from multiple  source files.<br>
 * First (and maybe only) application is in synchronisation of non audio/video
 * sources (e.g. time series data) with an empty media player. The SyncManager
 * can use this type to determine whether or not a selection  combobox should
 * be added to the player in synchronisation mode.
 *
 * @author Han Sloetjes, MPI
 */
public interface MultiSourcePlayer {
    /**
     * Returns the a String representation of the url / id of the currently
     * selected source.
     *
     * @return the id of the current source
     */
    public String getCurrentSource();

    /**
     * Sets the currently selected source by its id as a String.
     *
     * @param currentSource the id of the source that should be selected
     */
    public void setCurrentSource(String currentSource);

    /**
     * Returns the current sources (their id's) as an array of Strings.
     *
     * @return an array of id's
     */
    public String[] getDescriptorStrings();

    /**
     * Returns the current sources (their id's) as an array of
     * MediaDescriptors.
     *
     * @return an array of descriptors
     */
    public MediaDescriptor[] getDescriptors();

    /**
     * Sets the array of sources handled by this player.
     *
     * @param descriptors the array of sources
     */
    public void setDescriptors(MediaDescriptor[] descriptors);
}
